# -*- encoding: utf-8 -*-
=begin
= エンチャント設定

=end

#==============================================================================
# ■ NWConst::Enchantment
#==============================================================================
module NWConst::Enchantment
  #秘武器の所持数上限
  WEAPON_MAX_ITEM_NUMBER = 1000
  
  #秘防具の所持数上限
  ARMOR_MAX_ITEM_NUMBER = 2000
  
  #各能力値の基礎算出式 nが武器防具データベースで設定された数値 rがレア変数の値
  BASE_PARAM = "n+n/1000*r"
  
  #装備能力の分散度
  VARIANCE = 20
  
  #強化値の最大値
  MAX_PLUS_NUM = 9999999
 
  PLUS_UP_PRICE = "p*10000"

  #強化値の指定
  PLUS_NUM_DATA = {
    #レア変数の範囲
    1..500=>{ 
      #強化値とその確率
      0=>70 , 1=>30
    },
    501..1000=>{
      0=>40 , 1=>40 , 2=>20
    },
    1001..1500=>{
      1=>40 , 2=>40 , 3=>20
    },
    1501..2000=>{
      2=>40 , 3=>40 , 4=>20
    },
    2001..2500=>{
      3=>40 , 4=>40 , 5=>20
    },
    2501..3000=>{
      4=>40 , 5=>40 , 6=>20
    },
    3001..3500=>{
      5=>40 , 6=>40 , 7=>20
    },
    3501..4000=>{
      6=>40 , 7=>40 , 8=>20
    },
    4001..4500=>{
      7=>40 , 8=>40 , 9=>20
    },
    4501..5000=>{
      8=>40 , 9=>40 , 10=>20
    },
    5001..5500=>{
      9=>40 , 10=>40 , 11=>20
    },
    5501..6000=>{
      10=>40 , 11=>40 , 12=>20
    },
    6001..6500=>{
      11=>40 , 12=>40 , 13=>20
    },
    6501..7000=>{
      12=>40 , 13=>40 , 14=>20
    },
    7001..7500=>{
      13=>40 , 14=>40 , 15=>20
    },
    7501..8000=>{
      14=>40 , 15=>40 , 16=>20
    },
    8001..8500=>{
      15=>40 , 16=>40 , 17=>20
    },
    8501..9000=>{
      16=>40 , 17=>40 , 18=>20
    },
    9001..9500=>{
      17=>40 , 18=>40 , 19=>20
    },
    9501..10000=>{
      18=>40 , 19=>40 , 20=>20
    },
    10001..11000=>{
      20=>40 , 21=>40 , 22=>20
    },
    11001..12000=>{
      21=>40 , 22=>40 , 23=>20
    },
    12001..13000=>{
      23=>40 , 24=>40 , 25=>20
    },
    13001..14000=>{
      24=>40 , 25=>40 , 26=>20
    },
    14001..15000=>{
      25=>40 , 26=>40 , 27=>20
    },
    15001..15999=>{
      26=>40 , 27=>40 , 28=>20
    },
    16000..16999=>{
      27=>40 , 28=>40 , 29=>20
    },
    17000..17999=>{
      28=>40 , 29=>40 , 30=>20
    },
    18000..18999=>{
      29=>40 , 30=>40 , 31=>20
    },
    19000..19999=>{
      30=>40 , 31=>40 , 32=>20
    },
    20000..20999=>{
      31=>40 , 32=>40 , 33=>20
    },
    21000..21999=>{
      32=>40 , 33=>40 , 34=>20
    },
    22000..22999=>{
      33=>40 , 34=>40 , 35=>20
    },
    23000..23999=>{
      34=>40 , 35=>40 , 36=>20
    },
    24000..24999=>{
      35=>40 , 36=>40 , 37=>20
    },
    25000..30000=>{
      36=>40 , 37=>40 , 38=>20
    },
  }
  
  #特徴計算
  FEATURE_CALCULATION = {
    #分散度
    :variance => 20,
    1 => { # SPチャージ・薬の知識
      :value => "100+r/20",
      :max_value => 1000,
      :min_value => 101,
      :txt_value => "n-100",
    },
    2 =>{ # 命中率
      :value=>"r/100" ,
      :max_value => 200,
      :min_value => 5,
      :txt_value => "n",
    },
    3 =>{ # 会心率
      :value=>"r/200" ,
      :max_value => 100,
      :min_value => 5,
      :txt_value => "n",
    },
    4 =>{ # 回避率・魔法回避率・魔法反射率
      :value=>"r/400" ,
      :max_value => 50,
      :min_value => 5,
      :txt_value => "n",
    },
    5 =>{ # HP再生率
      :value=>"r/400" ,
      :max_value => 50,
      :min_value => 3,
      :txt_value => "n",
    },
    6 =>{ # MP再生率
      :value=>"r/1000" ,
      :max_value => 20,
      :min_value => 1,
      :txt_value => "n",
    },
    7 =>{ # SP再生率
      :value=>"r/400" ,
      :max_value => 50,
      :min_value => 3,
      :txt_value => "n",
    },
    8 =>{ # 反撃率・魔法反撃率
      :value=>"r/100" ,
      :max_value => 100,
      :min_value => 5,
      :txt_value => "n",
    },
    9 =>{ # MP・SP消費率
      :value=>"100-r*75/10000" ,
      :max_value => 75,
      :min_value => 10,
      :txt_value => "100-n",
    },
    10 =>{ # 属性・スキル強化
      :value=>"r/100" ,
      :max_value => 200,
      :min_value => 5,
      :txt_value => "n",
    },
    11 => { # 欠番？
      :value => "100+r/20",
      :max_value => 1000,
      :min_value => 100,
      :txt_value => "n",
    },
    12 =>{ # ステート付与
      :value=>"r/400" ,
      :max_value => 50,
      :min_value => 5,
      :txt_value => "n",
    },
    13 =>{ # 属性・ステート耐性
      :value=>"100-r/100" ,
      :max_value => 90,
      :min_value => 0,
      :txt_value => "100-n",
    },
    14 =>{ # 最終ボーナス
      :value=>"r/100" ,
      :max_value => 100,
      :min_value => 5,
      :txt_value => "n",
    },
    15 =>{ # 経験値・ゴールド・アイテム取得
      :value=>"100+r/40" ,
      :max_value => 600,
      :min_value => 101,
      :txt_value => "n-100",
    },
    16 =>{ # 能力値アップ
      :value=>"r/100" ,
      :max_value => 150,
      :min_value => 5,
      :txt_value => "n",
    },
    17 =>{ # 会心ダメージ
      :value=>"r/100" ,
      :max_value => 200,
      :min_value => 5,
      :txt_value => "n",
    },
    18 =>{ # 必中回避率
      :value=>"r/600" ,
      :max_value => 35,
      :min_value => 1,
      :txt_value => "n",
    },
    19 =>{ # 戦闘後HP回復
      :value=>"r/100" ,
      :max_value => 100,
      :min_value => 10,
      :txt_value => "n",
    },
    20 =>{ # 戦闘後MP回復
      :value=>"r/200" ,
      :max_value => 50,
      :min_value => 5,
      :txt_value => "n",
    },
    21 =>{ # マスタリー
      :value=>"250+r/100" ,
      :max_value => 500,
      :min_value => 250,
      :txt_value => "n",
    },
    22 =>{ # 職業アップ
      :value=>"r/400" ,
      :max_value => 50,
      :min_value => 5,
      :txt_value => "n",
    },
    23 =>{ # ダメージカット
      :value=>"r/2" ,
      :max_value => 10000,
      :min_value => 100,
      :txt_value => "n",
    },
    24 =>{ # 属性耐性25%
      :value=>"100-3*r/400" ,
      :max_value => 99,
      :min_value => 10,
      :txt_value => "100-n",
    },
    25 =>{ # 属性耐性50%
      :value=>"100-r/200" ,
      :max_value => 99,
      :min_value => 30,
      :txt_value => "100-n",
    },
    26 =>{ # 威力強化極大
      :value=>"200+r/60" ,
      :max_value => 600,
      :min_value => 200,
      :txt_value => "n",
    },
    27 =>{ # 消費極大
      :value=>"200+r/60" ,
      :max_value => 600,
      :min_value => 200,
      :txt_value => "n",
    },
    28 =>{ # ボーナスSP
      :value=>"r/400" ,
      :max_value => 40,
      :min_value => 1,
      :txt_value => "n",
    },
    29 =>{ # ボーナス能力値武器
      :value=>"140+r*0.14" ,
      :max_value => 99999,
      :min_value => 150,
      :txt_value => "n",
    },
    30 =>{ # ボーナスHP武器
      :value=>"750+r*0.75" ,
      :max_value => 9999999,
      :min_value => 750,
      :txt_value => "n",
    },
    31 =>{ # ボーナス能力値鎧
      :value=>"100+r*0.1" ,
      :max_value => 99999,
      :min_value => 100,
      :txt_value => "n",
    },
    32 =>{ # ボーナスHP鎧
      :value=>"500+r*0.5" ,
      :max_value => 9999999,
      :min_value => 500,
      :txt_value => "n",
    },
    33 =>{ # ボーナス能力値兜盾
      :value=>"40+r*0.04" ,
      :max_value => 99999,
      :min_value => 40,
      :txt_value => "n",
    },
    34 =>{ # ボーナスHP兜盾
      :value=>"250+r*0.25" ,
      :max_value => 9999999,
      :min_value => 250,
      :txt_value => "n",
    },
    41 =>{ # ダメージ軽減5%
      :value=>"100-r/2000" ,
      :max_value => 99,
      :min_value => 95,
      :txt_value => "100-n",
    },
    42 =>{ # ダメージ軽減10%
      :value=>"100-r/1000" ,
      :max_value => 99,
      :min_value => 90,
      :txt_value => "100-n",
    },
    43 =>{ # ダメージ軽減15%
      :value=>"100-r*3/2000" ,
      :max_value => 99,
      :min_value => 85,
      :txt_value => "100-n",
    },
    44 =>{ # ダメージ軽減20%
      :value=>"100-r/500" ,
      :max_value => 99,
      :min_value => 80,
      :txt_value => "100-n",
    },
    45 =>{ # ダメージ軽減25%
      :value=>"100-r/400" ,
      :max_value => 99,
      :min_value => 75,
      :txt_value => "100-n",
    },
    46 =>{ # ダメージ軽減30%
      :value=>"100-r*3/1000" ,
      :max_value => 99,
      :min_value => 70,
      :txt_value => "100-n",
    },
    47 =>{ # ダメージ軽減35%
      :value=>"100-r*7/2000" ,
      :max_value => 99,
      :min_value => 65,
      :txt_value => "100-n",
    },
    48 =>{ # ダメージ軽減40%
      :value=>"100-r*2/500" ,
      :max_value => 99,
      :min_value => 60,
      :txt_value => "100-n",
    },
    49 =>{ # ダメージ軽減45%
      :value=>"100-r*9/2000" ,
      :max_value => 99,
      :min_value => 55,
      :txt_value => "100-n",
    },
    50 =>{ # ダメージ軽減50%
      :value=>"100-r/200" ,
      :max_value => 99,
      :min_value => 50,
      :txt_value => "100-n",
    },
    51 =>{ # 個別スキル強化Ａ～
      :value=>"r/200" ,
      :max_value => 120,
      :min_value => 10,
      :txt_value => "n",
    },
    52 =>{ # 個別スキル強化Ｂ
      :value=>"r/120" ,
      :max_value => 200,
      :min_value => 10,
      :txt_value => "n",
    },
    53 =>{ # 個別スキル強化Ｃ
      :value=>"r/100" ,
      :max_value => 240,
      :min_value => 10,
      :txt_value => "n",
    },
    54 =>{ # 個別スキル強化Ｄ
      :value=>"r/80" ,
      :max_value => 300,
      :min_value => 10,
      :txt_value => "n",
    },
    55 =>{ # 個別スキル強化Ｅ
      :value=>"r/60" ,
      :max_value => 400,
      :min_value => 10,
      :txt_value => "n",
    },
    56 =>{ # 回復スキル強化
      :value=>"r/100" ,
      :max_value => 240,
      :min_value => 10,
      :txt_value => "n",
    },
  }

ENCHANTS = {
  # 短剣
  1 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 2, 1538 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 14, 1550 => 14, 1551 => 7, 1552 => 7,
        1553 => 6, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 40, 1608 => 10, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 1, 1624 => 10,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 10, 1629 => 1, 1630 => 40, 1631 => 1, 1632 => 20, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 20, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 10, 1669 => 1, 1670 => 40, 1671 => 10, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 20, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 30, 1709 => 30,
        1732 => 20, 1733 => 10, 1741 => 5, 1765 => 5, 1771 => 20, 1898 => 1},
  2 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 2, 2011 => 1,
        2012 => 2, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
  3 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 2, 2538 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 14, 2550 => 14, 2551 => 7, 2552 => 7,
        2553 => 6, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 40, 2608 => 10, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 1, 2624 => 10,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 10, 2629 => 1, 2630 => 40, 2631 => 1, 2632 => 20, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 20, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 10, 2669 => 1, 2670 => 40, 2671 => 10, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 20, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 30, 2709 => 30,
        2732 => 20, 2733 => 10, 2741 => 5, 2765 => 5, 2771 => 20, 2898 => 1},
  4 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 2, 3011 => 1,
        3012 => 2, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 剣
  5 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 1506 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 2, 1538 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 7, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 40, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 20, 1622 => 1, 1623 => 10, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 10, 1628 => 1, 1629 => 20, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 20, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 20, 1649 => 20, 1650 => 10, 1651 => 10, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 10, 1663 => 10, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 10, 1676 => 10, 1677 => 1, 1678 => 1, 1679 => 10,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1710 => 20, 1712 => 10, 1717 => 10, 1721 => 10, 1734 => 10, 1736 => 10, 1737 => 10, 1762 => 5, 1764 => 5, 1767 => 5, 
        1773 => 5, 1781 => 10, 1790 => 10, 1898 => 1},
  6 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
  7 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 2506 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 2, 2538 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 7, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 40, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 20, 2622 => 1, 2623 => 10, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 10, 2628 => 1, 2629 => 20, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 20, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 20, 2649 => 20, 2650 => 10, 2651 => 10, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 10, 2663 => 10, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 10, 2676 => 10, 2677 => 1, 2678 => 1, 2679 => 10,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2710 => 20, 2712 => 10, 2717 => 10, 2721 => 10, 2734 => 10, 2736 => 10, 2737 => 10, 2762 => 5, 2764 => 5, 2767 => 5, 
        2773 => 5, 2781 => 10, 2790 => 10, 2898 => 1},
  8 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 騎士剣
  9 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 1506 => 20,
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 7, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 40, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 20, 1622 => 1, 1623 => 10, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 10, 1628 => 1, 1629 => 20, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 20, 1649 => 20, 1650 => 10, 1651 => 10, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 10, 1663 => 10, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 10, 1676 => 10, 1677 => 1, 1678 => 1, 1679 => 10,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1710 => 20, 1712 => 5, 1721 => 10, 1736 => 10, 1762 => 10, 1764 => 10, 1767 => 5, 1773 => 5, 1781 => 10, 1790 => 10, 1898 => 1},
 10 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 11 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 2506 => 20,
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 7, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 40, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 20, 2622 => 1, 2623 => 10, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 10, 2628 => 1, 2629 => 20, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 20, 2649 => 20, 2650 => 10, 2651 => 10, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 10, 2663 => 10, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 10, 2676 => 10, 2677 => 1, 2678 => 1, 2679 => 10,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2710 => 20, 2712 => 5, 2721 => 10, 2736 => 10, 2762 => 10, 2764 => 10, 2767 => 5, 2773 => 5, 2781 => 10, 2790 => 10, 2898 => 1},
 12 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 巨剣
 13 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 1506 => 20,
        1526 => 7, 1527 => 14, 1528 => 14, 1529 => 14, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 14, 1548 => 7, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 40, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 20, 1622 => 1, 1623 => 1, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 20, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 1, 1663 => 10, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 1, 1677 => 1, 1678 => 1, 1679 => 10,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1710 => 20, 1721 => 10, 1734 => 10, 1737 => 10, 1781 => 10, 1898 => 1, 1902 => 1, 1903 => 5, 1904 => 5},
 14 => {2000 => 2, 2003 => 4, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 15 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 2506 => 20,
        2526 => 7, 2527 => 14, 2528 => 14, 2529 => 14, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 14, 2548 => 7, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 40, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 20, 2622 => 1, 2623 => 1, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 20, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 1, 2663 => 10, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 1, 2677 => 1, 2678 => 1, 2679 => 10,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2710 => 20, 2721 => 10, 2734 => 10, 2737 => 10, 2781 => 10, 2898 => 1, 2902 => 1, 2903 => 5, 2904 => 5},
 16 => {3000 => 2, 3003 => 4, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 尖剣
 17 => {1502 => 20, 1503 => 20, 1504 => 20, 1506 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 7, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 7, 1538 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 14, 1550 => 14, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 20, 1609 => 40, 1610 => 1, 1611 => 20, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 20, 1622 => 1, 1623 => 1, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 20, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 40, 1649 => 1, 1650 => 1, 1651 => 20, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 20, 1669 => 1, 1670 => 1, 1671 => 10, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 20, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1710 => 5, 1713 => 5, 1721 => 5, 1736 => 5, 1762 => 10, 1768 => 20, 1898 => 1},
 18 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 2, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 19 => {2502 => 20, 2503 => 20, 2504 => 20, 2506 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 7, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 7, 2538 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 14, 2550 => 14, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 20, 2609 => 40, 2610 => 1, 2611 => 20, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 20, 2622 => 1, 2623 => 1, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 20, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 40, 2649 => 1, 2650 => 1, 2651 => 20, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 20, 2669 => 1, 2670 => 1, 2671 => 10, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 20, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2710 => 5, 2713 => 5, 2721 => 5, 2736 => 5, 2762 => 10, 2768 => 20, 2898 => 1},
 20 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 2, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 魔導剣
 21 => {1502 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 7, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 7, 1538 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 40, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 10, 1624 => 40,
        1625 => 20, 1626 => 20, 1627 => 1, 1628 => 1, 1629 => 40, 1630 => 40, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 10, 1651 => 20, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 10, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 40, 1669 => 20, 1670 => 40, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 10, 1676 => 20, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1710 => 10, 1712 => 20, 1717 => 10, 1722 => 10, 1723 => 5, 1724 => 5, 1727 => 10, 1773 => 10, 1898 => 20, 1899 => 5, 1900 => 5, 1901 => 5},
 22 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 5, 2008 => 5, 2009 => 2, 2010 => 1, 2011 => 2,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 23 => {2502 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 7, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 7, 2538 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 40, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 10, 2624 => 40,
        2625 => 20, 2626 => 20, 2627 => 1, 2628 => 1, 2629 => 40, 2630 => 40, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 10, 2651 => 20, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 10, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 40, 2669 => 20, 2670 => 40, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 10, 2676 => 20, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2710 => 10, 2712 => 20, 2717 => 10, 2722 => 10, 2723 => 5, 2724 => 5, 2727 => 10, 2773 => 10, 2898 => 20, 2899 => 5, 2900 => 5, 2901 => 5},
 24 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 5, 3008 => 5, 3009 => 2, 3010 => 1, 3011 => 2,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 槍
 25 => {1502 => 20, 1503 => 20, 1504 => 20, 1506 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 14, 1550 => 14, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 20, 1610 => 1, 1611 => 40, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 20, 1622 => 1, 1623 => 10, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 20, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 10, 1632 => 1, 1633 => 20, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 10, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 1, 1653 => 1, 1654 => 10,
        1655 => 1, 1656 => 1, 1657 => 20, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 10, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 1, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1711 => 10, 1713 => 20, 1721 => 10, 1736 => 10, 1737 => 10, 1776 => 5, 1780 => 10, 1790 => 10, 1898 => 1},
 26 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 27 => {2502 => 20, 2503 => 20, 2504 => 20, 2506 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 14, 2550 => 14, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 20, 2610 => 1, 2611 => 40, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 20, 2622 => 1, 2623 => 10, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 20, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 10, 2632 => 1, 2633 => 20, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 10, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 1, 2653 => 1, 2654 => 10,
        2655 => 1, 2656 => 1, 2657 => 20, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 10, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 1, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2711 => 10, 2713 => 20, 2721 => 10, 2736 => 10, 2737 => 10, 2776 => 5, 2780 => 10, 2790 => 10, 2898 => 1},
 28 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 重槍
 29 => {1502 => 20, 1503 => 20, 1504 => 20, 1506 => 20,
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 14, 1550 => 14, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 20, 1610 => 1, 1611 => 40, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 20, 1622 => 1, 1623 => 10, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 20, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 10, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 10, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 1, 1653 => 1, 1654 => 10,
        1655 => 1, 1656 => 1, 1657 => 20, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 10, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 1, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1711 => 10, 1713 => 20, 1721 => 10, 1776 => 5, 1780 => 10, 1790 => 10, 1898 => 1},
 30 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 31 => {2502 => 20, 2503 => 20, 2504 => 20, 2506 => 20,
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 14, 2550 => 14, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 20, 2610 => 1, 2611 => 40, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 20, 2622 => 1, 2623 => 10, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 20, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 10, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 10, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 1, 2653 => 1, 2654 => 10,
        2655 => 1, 2656 => 1, 2657 => 20, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 10, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 1, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2711 => 10, 2713 => 20, 2721 => 10, 2776 => 5, 2780 => 10, 2790 => 10, 2898 => 1},
 32 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 刀
 33 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 20, 1609 => 1, 1610 => 40, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 20, 1622 => 1, 1623 => 1, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 10, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 10, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 1, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1714 => 20, 1769 => 10, 1779 => 10, 1898 => 1},
 34 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 35 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 20, 2609 => 1, 2610 => 40, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 20, 2622 => 1, 2623 => 1, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 10, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 10, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 1, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2714 => 20, 2769 => 10, 2779 => 10, 2898 => 1},
 36 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 忍者刀
 37 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 14, 1550 => 14, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 50, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 20, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 1, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 10, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 40, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 10, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 20, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 20, 1676 => 10, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1733 => 20, 1741 => 5, 1771 => 10, 1777 => 10, 1898 => 1},
 38 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 1, 2010 => 2, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 39 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 14, 2550 => 14, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 50, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 20, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 1, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 10, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 40, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 10, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 20, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 20, 2676 => 10, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2733 => 20, 2741 => 5, 2771 => 10, 2777 => 10, 2898 => 1},
 40 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 1, 3010 => 2, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 拳
 41 => {1502 => 20, 1503 => 20, 1504 => 20, 
        1526 => 7, 1527 => 14, 1528 => 14, 1529 => 14, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 14, 1534 => 14, 1535 => 14,
        1536 => 14, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 14, 1548 => 7, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 30, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 40, 1623 => 1, 1624 => 10,
        1625 => 1, 1626 => 1, 1627 => 20, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 20,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 10, 1651 => 10, 1652 => 1, 1653 => 1, 1654 => 20,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 20, 1659 => 1, 1660 => 1, 1661 => 10, 1662 => 10, 1663 => 10, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 10, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 10, 1676 => 10, 1677 => 20, 1678 => 1, 1679 => 10,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1718 => 20, 1719 => 10, 1720 => 10, 1738 => 10, 1767 => 5, 1768 => 5, 1770 => 5, 1776 => 10, 1781 => 10, 1784 => 10, 1789 => 5, 1898 => 10, 1900 => 5, 1901 => 5},
 42 => {2000 => 2, 2003 => 4, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 43 => {2502 => 20, 2503 => 20, 2504 => 20, 
        2526 => 7, 2527 => 14, 2528 => 14, 2529 => 14, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 14, 2534 => 14, 2535 => 14,
        2536 => 14, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 14, 2548 => 7, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 30, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 40, 2623 => 1, 2624 => 10,
        2625 => 1, 2626 => 1, 2627 => 20, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 20,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 10, 2651 => 10, 2652 => 1, 2653 => 1, 2654 => 20,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 20, 2659 => 1, 2660 => 1, 2661 => 10, 2662 => 10, 2663 => 10, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 10, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 10, 2676 => 10, 2677 => 20, 2678 => 1, 2679 => 10,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2718 => 20, 2719 => 10, 2720 => 10, 2738 => 10, 2767 => 5, 2768 => 5, 2770 => 5, 2776 => 10, 2781 => 10, 2784 => 10, 2789 => 5, 2898 => 10, 2900 => 5, 2901 => 5},
 44 => {3000 => 2, 3003 => 4, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 牙
 45 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 1506 => 20, 
        1526 => 7, 1527 => 14, 1528 => 14, 1529 => 14, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 14, 1534 => 14, 1535 => 14,
        1536 => 14, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 14, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 50, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 20, 1623 => 1, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 10, 1652 => 1, 1653 => 1, 1654 => 40,
        1655 => 1, 1656 => 1, 1657 => 20, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 10, 1662 => 10, 1663 => 40, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 10, 1677 => 1, 1678 => 1, 1679 => 40,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1718 => 10, 1768 => 5, 1771 => 10, 1776 => 20, 1777 => 5, 1780 => 5, 1781 => 20, 1782 => 5, 1789 => 5, 1898 => 1},
 46 => {2000 => 2, 2003 => 4, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 1, 2010 => 1, 2011 => 1,
        2012 => 2, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 47 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 2506 => 20, 
        2526 => 7, 2527 => 14, 2528 => 14, 2529 => 14, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 14, 2534 => 14, 2535 => 14,
        2536 => 14, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 14, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 50, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 20, 2623 => 1, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 10, 2652 => 1, 2653 => 1, 2654 => 40,
        2655 => 1, 2656 => 1, 2657 => 20, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 10, 2662 => 10, 2663 => 40, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 10, 2677 => 1, 2678 => 1, 2679 => 40,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2718 => 10, 2768 => 5, 2771 => 10, 2776 => 20, 2777 => 5, 2780 => 5, 2781 => 20, 2782 => 5, 2789 => 5, 2898 => 1},
 48 => {3000 => 2, 3003 => 4, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 1, 3010 => 1, 3011 => 1,
        3012 => 2, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 斧
 49 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 1506 => 20,
        1526 => 7, 1527 => 14, 1528 => 14, 1529 => 14, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 14, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 40, 1613 => 20, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 20, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 1, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 20, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 1, 1653 => 1, 1654 => 10,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 10, 1662 => 10, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 1, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1715 => 10, 1716 => 20, 1734 => 10, 1769 => 5, 1774 => 5, 1776 => 5, 1788 => 5, 1898 => 1, 1903 => 5, 1904 => 5},
 50 => {2000 => 2, 2003 => 4, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 51 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 2506 => 20,
        2526 => 7, 2527 => 14, 2528 => 14, 2529 => 14, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 14, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 40, 2613 => 20, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 20, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 1, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 20, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 1, 2653 => 1, 2654 => 10,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 10, 2662 => 10, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 1, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2715 => 10, 2716 => 20, 2734 => 10, 2769 => 5, 2774 => 5, 2776 => 5, 2788 => 5, 2898 => 1, 2903 => 5, 2904 => 5},
 52 => {3000 => 2, 3003 => 4, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 棍
 53 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 1506 => 20,
        1526 => 7, 1527 => 14, 1528 => 14, 1529 => 14, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 14, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 30,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 20, 1613 => 40, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 20, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 10, 1623 => 10, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 10, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 20, 1661 => 10, 1662 => 10, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 1, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1715 => 20, 1716 => 10, 1718 => 5, 1720 => 5, 1726 => 5, 1769 => 5, 1774 => 5, 1786 => 10, 1788 => 5, 1898 => 1, 1900 => 3, 1901 => 3, 1903 => 5, 1904 => 5},
 54 => {2000 => 2, 2003 => 4, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 55 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 2506 => 20,
        2526 => 7, 2527 => 14, 2528 => 14, 2529 => 14, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 14, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 30,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 20, 2613 => 40, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 20, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 10, 2623 => 10, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 10, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 20, 2661 => 10, 2662 => 10, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 1, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2715 => 20, 2716 => 10, 2718 => 5, 2720 => 5, 2726 => 5, 2769 => 5, 2774 => 5, 2786 => 10, 2788 => 5, 2898 => 1, 2900 => 3, 2901 => 3, 2903 => 5, 2904 => 5},
 56 => {3000 => 2, 3003 => 4, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 鎌
 57 => {1502 => 20, 1504 => 20, 1505 => 20, 1506 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 7, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 7, 1538 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 20, 1595 => 20, 1596 => 20, 1597 => 20, 1598 => 20, 1599 => 20, 1600 => 20, 1601 => 20,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 40,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 1, 1624 => 20,
        1625 => 20, 1626 => 40, 1627 => 1, 1628 => 20, 1629 => 1, 1630 => 40, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 20, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 10, 1659 => 1, 1660 => 20, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 40, 1667 => 1, 1668 => 40, 1669 => 20, 1670 => 40, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 20, 1677 => 10, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1722 => 10, 1723 => 10, 1724 => 10, 1725 => 10, 1755 => 10, 1766 => 5, 1767 => 10, 1769 => 10, 1784 => 5, 1787 => 10, 1898 => 10, 1900 => 10, 1901 => 10},
 58 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 5, 2008 => 5, 2009 => 2, 2010 => 1, 2011 => 2,
        2012 => 2, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 59 => {2502 => 20, 2504 => 20, 2505 => 20, 2506 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 7, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 7, 2538 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 20, 2595 => 20, 2596 => 20, 2597 => 20, 2598 => 20, 2599 => 20, 2600 => 20, 2601 => 20,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 40,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 1, 2624 => 20,
        2625 => 20, 2626 => 40, 2627 => 1, 2628 => 20, 2629 => 1, 2630 => 40, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 20, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 10, 2659 => 1, 2660 => 20, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 40, 2667 => 1, 2668 => 40, 2669 => 20, 2670 => 40, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 20, 2677 => 10, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2722 => 10, 2723 => 10, 2724 => 10, 2725 => 10, 2755 => 10, 2766 => 5, 2767 => 10, 2769 => 10, 2784 => 5, 2787 => 10, 2898 => 10, 2900 => 10, 2901 => 10},
 60 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 5, 3008 => 5, 3009 => 2, 3010 => 1, 3011 => 2,
        3012 => 2, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 3},

  # 杖
 61 => {1501 => 20, 1502 => 20, 1505 => 20, 1506 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 7, 1532 => 2, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 7, 1538 => 2, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 2, 1552 => 2,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 20, 1595 => 20, 1596 => 20, 1597 => 20, 1598 => 20, 1599 => 20, 1600 => 20, 1601 => 20,
        1602 => 10, 1603 => 10, 1604 => 100,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 40, 1624 => 20,
        1625 => 1, 1626 => 1, 1627 => 20, 1628 => 1, 1629 => 1, 1630 => 20, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 10,
        1635 => 10, 1636 => 1, 1637 => 10, 1638 => 10, 1639 => 20, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 10, 1647 => 1, 1648 => 10, 1649 => 1, 1650 => 1, 1651 => 10, 1652 => 10, 1653 => 10, 1654 => 1,
        1655 => 10, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 20, 1660 => 1, 1661 => 1, 1662 => 10, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 20, 1669 => 20, 1670 => 20, 1671 => 10, 1672 => 20, 1673 => 1, 1674 => 10,
        1675 => 1, 1676 => 10, 1677 => 1, 1678 => 20, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1720 => 5, 1722 => 5, 1726 => 20, 1727 => 10, 1728 => 5, 1758 => 5, 1763 => 5, 1768 => 5, 1772 => 10, 1774 => 10, 
        1775 => 5, 1778 => 5, 1785 => 10, 1790 => 5, 1898 => 10, 1900 => 5, 1901 => 5},
 62 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 1, 2007 => 5, 2008 => 5, 2009 => 1, 2010 => 1, 2011 => 2,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 63 => {2501 => 20, 2502 => 20, 2505 => 20, 2506 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 7, 2532 => 2, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 7, 2538 => 2, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 2, 2552 => 2,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 20, 2595 => 20, 2596 => 20, 2597 => 20, 2598 => 20, 2599 => 20, 2600 => 20, 2601 => 20,
        2602 => 10, 2603 => 10, 2604 => 100,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 40, 2624 => 20,
        2625 => 1, 2626 => 1, 2627 => 20, 2628 => 1, 2629 => 1, 2630 => 20, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 10,
        2635 => 10, 2636 => 1, 2637 => 10, 2638 => 10, 2639 => 20, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 10, 2647 => 1, 2648 => 10, 2649 => 1, 2650 => 1, 2651 => 10, 2652 => 10, 2653 => 10, 2654 => 1,
        2655 => 10, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 20, 2660 => 1, 2661 => 1, 2662 => 10, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 20, 2669 => 20, 2670 => 20, 2671 => 10, 2672 => 20, 2673 => 1, 2674 => 10,
        2675 => 1, 2676 => 10, 2677 => 1, 2678 => 20, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2720 => 5, 2722 => 5, 2726 => 20, 2727 => 10, 2728 => 5, 2758 => 5, 2763 => 5, 2768 => 5, 2772 => 10, 2774 => 10, 
        2775 => 5, 2778 => 5, 2785 => 10, 2790 => 5, 2898 => 10, 1900 => 5, 1901 => 5},
 64 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 1, 3007 => 5, 3008 => 5, 3009 => 1, 3010 => 1, 3011 => 2,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 3},


  # ロッド
 65 => {1501 => 20, 1502 => 20, 1505 => 20, 1506 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 7, 1532 => 2, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 7, 1538 => 2, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 2, 1552 => 2,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 30, 1595 => 30, 1596 => 30, 1597 => 30, 1598 => 30, 1599 => 30, 1600 => 30, 1601 => 30,
        1602 => 10, 1603 => 10, 1604 => 30,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 20, 1624 => 40,
        1625 => 40, 1626 => 40, 1627 => 1, 1628 => 40, 1629 => 1, 1630 => 40, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 10,
        1635 => 10, 1636 => 1, 1637 => 10, 1638 => 10, 1639 => 10, 1640 => 1, 1641 => 10, 1642 => 10, 1643 => 10, 1644 => 1,
        1645 => 1, 1646 => 10, 1647 => 1, 1648 => 10, 1649 => 1, 1650 => 10, 1651 => 20, 1652 => 10, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 10, 1659 => 10, 1660 => 10, 1661 => 1, 1662 => 20, 1663 => 10, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 40, 1669 => 40, 1670 => 40, 1671 => 10, 1672 => 10, 1673 => 1, 1674 => 10,
        1675 => 10, 1676 => 20, 1677 => 10, 1678 => 10, 1679 => 10,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1722 => 20, 1723 => 10, 1724 => 10, 1725 => 10, 1726 => 5, 1727 => 10, 1728 => 10, 1751 => 5, 1755 => 5, 1762 => 5, 
        1766 => 5, 1768 => 5, 1769 => 5, 1770 => 5, 1771 => 5, 1772 => 5, 1774 => 10, 1777 => 5, 1784 => 5, 1785 => 5, 
        1786 => 5, 1787 => 5, 1898 => 20, 1899 => 5, 1900 => 5, 1901 => 5},
 66 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 1, 2007 => 5, 2008 => 5, 2009 => 1, 2010 => 1, 2011 => 2,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 67 => {2501 => 20, 2502 => 20, 2505 => 20, 2506 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 7, 2532 => 2, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 7, 2538 => 2, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 2, 2552 => 2,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 30, 2595 => 30, 2596 => 30, 2597 => 30, 2598 => 30, 2599 => 30, 2600 => 30, 2601 => 30,
        2602 => 10, 2603 => 10, 2604 => 30,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 20, 2624 => 40,
        2625 => 40, 2626 => 40, 2627 => 1, 2628 => 40, 2629 => 1, 2630 => 40, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 10,
        2635 => 10, 2636 => 1, 2637 => 10, 2638 => 10, 2639 => 10, 2640 => 1, 2641 => 10, 2642 => 10, 2643 => 10, 2644 => 1,
        2645 => 1, 2646 => 10, 2647 => 1, 2648 => 10, 2649 => 1, 2650 => 10, 2651 => 20, 2652 => 10, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 10, 2659 => 10, 2660 => 10, 2661 => 1, 2662 => 20, 2663 => 10, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 40, 2669 => 40, 2670 => 40, 2671 => 10, 2672 => 10, 2673 => 1, 2674 => 10,
        2675 => 10, 2676 => 20, 2677 => 10, 2678 => 10, 2679 => 10,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2722 => 20, 2723 => 10, 2724 => 10, 2725 => 10, 2726 => 5, 2727 => 10, 2728 => 10, 2751 => 5, 2755 => 5, 2762 => 5, 
        2766 => 5, 2768 => 5, 2769 => 5, 2770 => 5, 2771 => 5, 2772 => 5, 2774 => 10, 2777 => 5, 2784 => 5, 2785 => 5, 
        2786 => 5, 2787 => 5, 2898 => 20, 2899 => 5, 1900 => 5, 1901 => 5},
 68 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 1, 3007 => 5, 3008 => 5, 3009 => 1, 3010 => 1, 3011 => 2,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 3},

  # 弓矢
 69 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 14, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 30, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 40, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 10, 1624 => 10,
        1625 => 1, 1626 => 1, 1627 => 10, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 10, 1651 => 10, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 20, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 10, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 10, 1676 => 10, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1729 => 20, 1773 => 10, 1782 => 5, 1790 => 5, 1898 => 1},
 70 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 71 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 14, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 30, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 40, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 10, 2624 => 10,
        2625 => 1, 2626 => 1, 2627 => 10, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 10, 2651 => 10, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 20, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 10, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 10, 2676 => 10, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2729 => 20, 2773 => 10, 2782 => 5, 2790 => 5, 2898 => 1},
 72 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 鞭
 73 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 40, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 20, 1622 => 1, 1623 => 10, 1624 => 10,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 20, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 20, 1648 => 10, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 20, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 40, 1657 => 1, 1658 => 10, 1659 => 40, 1660 => 1, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 40, 1668 => 10, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 1, 1677 => 10, 1678 => 40, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1731 => 20, 1732 => 5, 1745 => 5, 1762 => 5, 1779 => 10, 1783 => 5, 1784 => 5, 1785 => 10, 1898 => 10},
 74 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 2, 2011 => 1,
        2012 => 2, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 75 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 40, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 20, 2622 => 1, 2623 => 10, 2624 => 10,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 20, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 20, 2648 => 10, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 20, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 40, 2657 => 1, 2658 => 10, 2659 => 40, 2660 => 1, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 40, 2668 => 10, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 1, 2677 => 10, 2678 => 40, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2731 => 20, 2732 => 5, 2745 => 5, 2762 => 5, 2779 => 10, 2783 => 5, 2784 => 5, 2785 => 10, 2898 => 10},
 76 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 2, 3011 => 1,
        3012 => 2, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 竪琴
 77 => {1501 => 20, 1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 7, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 7, 1538 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 100, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 20, 1624 => 20,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 20, 1636 => 1, 1637 => 1, 1638 => 20, 1639 => 40, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 20, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 10, 1652 => 20, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 10, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 10, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 20, 1669 => 1, 1670 => 1, 1671 => 20, 1672 => 40, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 10, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1747 => 20, 1749 => 5, 1772 => 20, 1783 => 5, 1788 => 5, 1898 => 1},
 78 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 1, 2010 => 2, 2011 => 1,
        2012 => 2, 2013 => 1, 2051 => 2, 2052 => 3, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 79 => {2501 => 20, 2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 7, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 7, 2538 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 100, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 20, 2624 => 20,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 20, 2636 => 1, 2637 => 1, 2638 => 20, 2639 => 40, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 20, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 10, 2652 => 20, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 10, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 10, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 20, 2669 => 1, 2670 => 1, 2671 => 20, 2672 => 40, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 10, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2747 => 20, 2749 => 5, 2772 => 20, 2783 => 5, 2788 => 5, 2898 => 1},
 80 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 1, 3010 => 2, 3011 => 1,
        3012 => 2, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # ブーメラン
 81 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 40, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 1, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 20, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 40, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 40, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 1, 1653 => 40, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 40, 1674 => 1,
        1675 => 1, 1676 => 1, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1729 => 5, 1732 => 5, 1740 => 10, 1741 => 5, 1756 => 10, 1775 => 20, 1898 => 1},
 82 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 2, 2011 => 1,
        2012 => 2, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 83 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 40, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 1, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 20, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 40, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 40, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 1, 2653 => 40, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 40, 2674 => 1,
        2675 => 1, 2676 => 1, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2729 => 5, 2732 => 5, 2740 => 10, 2741 => 5, 2756 => 10, 2775 => 20, 2898 => 1},
 84 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 2, 3011 => 1,
        3012 => 2, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 鉄球
 85 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 1506 => 20,
        1526 => 7, 1527 => 14, 1528 => 14, 1529 => 14, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 14, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 20, 1613 => 20, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 40, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 10, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 20, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 10, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 40, 1656 => 1, 1657 => 1, 1658 => 10, 1659 => 1, 1660 => 1, 1661 => 10, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 20, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 10, 1677 => 10, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1715 => 20, 1716 => 5, 1778 => 20, 1784 => 5, 1788 => 5, 1898 => 1},
 86 => {2000 => 2, 2003 => 4, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 2, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 87 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 2506 => 20,
        2526 => 7, 2527 => 14, 2528 => 14, 2529 => 14, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 14, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 20, 2613 => 20, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 40, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 10, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 20, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 10, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 40, 2656 => 1, 2657 => 1, 2658 => 10, 2659 => 1, 2660 => 1, 2661 => 10, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 20, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 10, 2677 => 10, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2715 => 20, 2716 => 5, 2778 => 20, 2784 => 5, 2788 => 5, 2898 => 1},
 88 => {3000 => 2, 3003 => 4, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 2, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 扇
 89 => {1501 => 20, 1502 => 20, 1503 => 20, 1504 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 7, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 7, 1538 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 50, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 40, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 10, 1624 => 20,
        1625 => 20, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 40, 1631 => 10, 1632 => 20, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 10, 1638 => 40, 1639 => 20, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 10, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 10, 1652 => 20, 1653 => 1, 1654 => 10,
        1655 => 10, 1656 => 1, 1657 => 20, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 20, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 20, 1669 => 20, 1670 => 40, 1671 => 40, 1672 => 20, 1673 => 1, 1674 => 1,
        1675 => 10, 1676 => 10, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1722 => 5, 1725 => 10, 1745 => 5, 1746 => 20, 1749 => 5, 1774 => 5, 1777 => 10, 1778 => 5, 1780 => 10, 1783 => 5, 1898 => 1, 1900 => 5, 1901 => 5},
 90 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 2, 2011 => 2,
        2012 => 2, 2013 => 1, 2051 => 2, 2052 => 3, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 91 => {2501 => 20, 2502 => 20, 2503 => 20, 2504 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 7, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 7, 2538 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 50, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 40, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 10, 2624 => 20,
        2625 => 20, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 40, 2631 => 10, 2632 => 20, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 10, 2638 => 40, 2639 => 20, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 10, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 10, 2652 => 20, 2653 => 1, 2654 => 10,
        2655 => 10, 2656 => 1, 2657 => 20, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 20, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 20, 2669 => 20, 2670 => 40, 2671 => 40, 2672 => 20, 2673 => 1, 2674 => 1,
        2675 => 10, 2676 => 10, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2722 => 5, 2725 => 10, 2745 => 5, 2746 => 20, 2749 => 5, 2774 => 5, 2777 => 10, 2778 => 5, 2780 => 10, 2783 => 5, 2898 => 1, 1900 => 5, 1901 => 5},
 92 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 2, 3011 => 2,
        3012 => 2, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 包丁
 93 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 10, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 1, 1624 => 10,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 20, 1631 => 1, 1632 => 20, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 10, 1639 => 10, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 40, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 1, 1653 => 1, 1654 => 10,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 10, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 10, 1669 => 1, 1670 => 20, 1671 => 10, 1672 => 10, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 1, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10, 1757 => 20, 1777 => 5, 1898 => 1},
 94 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 1, 2010 => 2, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 3, 2064 => 2, 2065 => 2},
 95 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 10, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 1, 2624 => 10,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 20, 2631 => 1, 2632 => 20, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 10, 2639 => 10, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 40, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 1, 2653 => 1, 2654 => 10,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 10, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 10, 2669 => 1, 2670 => 20, 2671 => 10, 2672 => 10, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 1, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10, 2757 => 20, 2777 => 5, 2898 => 1},
 96 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 1, 3010 => 2, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # そろばん
 97 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 10, 1624 => 10,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 40, 1636 => 20, 1637 => 1, 1638 => 1, 1639 => 20, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 20, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 10, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 20, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 1, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10, 1739 => 20, 1740 => 10, 1772 => 5, 1898 => 1},
 98 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 1, 2010 => 2, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
 99 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 10, 2624 => 10,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 40, 2636 => 20, 2637 => 1, 2638 => 1, 2639 => 20, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 20, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 10, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 20, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 1, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10, 2739 => 20, 2740 => 10, 2772 => 5, 2898 => 1},
100 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 1, 3010 => 2, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # メス
101 => {1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 7, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 7, 1538 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 50, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 100, 1604 => 100,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 1, 1624 => 1,
        1625 => 1, 1626 => 20, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 10, 1642 => 10, 1643 => 10, 1644 => 1,
        1645 => 1, 1646 => 40, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 20, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 40,
        1675 => 1, 1676 => 1, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10, 1751 => 5, 1755 => 5, 1758 => 20, 1786 => 5, 1898 => 1},
102 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 1, 2010 => 2, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 2, 2064 => 2, 2065 => 2},
103 => {2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 7, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 7, 2538 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 50, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 100, 2604 => 100,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 1, 2624 => 1,
        2625 => 1, 2626 => 20, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 10, 2642 => 10, 2643 => 10, 2644 => 1,
        2645 => 1, 2646 => 40, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 20, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 40,
        2675 => 1, 2676 => 1, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10, 2751 => 5, 2755 => 5, 2758 => 20, 2786 => 5, 2898 => 1},
104 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 1, 3010 => 2, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # カード
105 => {1501 => 20, 1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 10, 1624 => 10,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 40, 1638 => 20, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 10, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 10, 1669 => 1, 1670 => 1, 1671 => 20, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 1, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 30, 1706 => 30, 1707 => 30, 1708 => 10, 1709 => 10, 1742 => 20, 1743 => 20, 1774 => 10, 1898 => 1},
106 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 1, 2010 => 2, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
107 => {2501 => 20, 2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 10, 2624 => 10,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 40, 2638 => 20, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 10, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 10, 2669 => 1, 2670 => 1, 2671 => 20, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 1, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 30, 2706 => 30, 2707 => 30, 2708 => 10, 2709 => 10, 2742 => 20, 2743 => 20, 2774 => 10, 2898 => 1},
108 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 1, 3010 => 2, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 皿
109 => {1501 => 20, 1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 7, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 7, 1538 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 50, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 30,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 10, 1622 => 1, 1623 => 1, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 10, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 20, 1647 => 40, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 10, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 40, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 20, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 10, 1673 => 1, 1674 => 20,
        1675 => 1, 1676 => 10, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 30, 1706 => 30, 1707 => 30, 1708 => 10, 1709 => 10, 1759 => 20, 1779 => 10, 1788 => 10, 1898 => 1},
110 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 1, 2010 => 2, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 2, 2064 => 2, 2065 => 2},
111 => {2501 => 20, 2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 7, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 7, 2538 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 50, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 30,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 10, 2622 => 1, 2623 => 1, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 10, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 20, 2647 => 40, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 10, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 40, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 20, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 10, 2673 => 1, 2674 => 20,
        2675 => 1, 2676 => 10, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 30, 2706 => 30, 2707 => 30, 2708 => 10, 2709 => 10, 2759 => 20, 2779 => 10, 2788 => 10, 2898 => 1},
112 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 1, 3010 => 2, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 魔導書
113 => {1501 => 20, 1502 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 7, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 7, 1538 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 30, 1595 => 30, 1596 => 30, 1597 => 30, 1598 => 30, 1599 => 30, 1600 => 30, 1601 => 30,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 1, 1624 => 40,
        1625 => 20, 1626 => 20, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 40, 1642 => 40, 1643 => 40, 1644 => 1,
        1645 => 1, 1646 => 20, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 10, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 20, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 40, 1669 => 20, 1670 => 20, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 20,
        1675 => 1, 1676 => 10, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1722 => 10, 1723 => 5, 1724 => 10, 1751 => 20, 1752 => 20, 1753 => 20, 1755 => 20, 1786 => 5, 1787 => 5, 1898 => 10},
114 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 5, 2008 => 5, 2009 => 1, 2010 => 2, 2011 => 2,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
115 => {2501 => 20, 2502 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 7, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 7, 2538 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 30, 2595 => 30, 2596 => 30, 2597 => 30, 2598 => 30, 2599 => 30, 2600 => 30, 2601 => 30,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 1, 2624 => 40,
        2625 => 20, 2626 => 20, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 40, 2642 => 40, 2643 => 40, 2644 => 1,
        2645 => 1, 2646 => 20, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 10, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 20, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 40, 2669 => 20, 2670 => 20, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 20,
        2675 => 1, 2676 => 10, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2722 => 10, 2723 => 5, 2724 => 10, 2751 => 20, 2752 => 20, 2753 => 20, 2755 => 20, 2786 => 5, 2787 => 5, 2898 => 10},
116 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 5, 3008 => 5, 3009 => 1, 3010 => 2, 3011 => 2,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 銃
117 => {1501 => 20, 1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 14, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 2, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1531 => 2, 1532 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 30, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 40, 1621 => 1, 1622 => 1, 1623 => 1, 1624 => 1,
        1625 => 1, 1626 => 20, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 20, 1634 => 20,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 40,
        1645 => 1, 1646 => 1, 1647 => 10, 1648 => 20, 1649 => 1, 1650 => 1, 1651 => 10, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 20, 1662 => 1, 1663 => 10, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 10,
        1675 => 1, 1676 => 10, 1677 => 1, 1678 => 1, 1679 => 10,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1728 => 5, 1730 => 20, 1734 => 5, 1737 => 5, 1744 => 5, 1751 => 5, 1754 => 10, 1755 => 5, 1762 => 5, 1788 => 5,
        1789 => 5, 1898 => 1, 1902 => 5},
118 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 2, 2010 => 1, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
119 => {2501 => 20, 2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 14, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 2, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2531 => 2, 2532 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 30, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 40, 2621 => 1, 2622 => 1, 2623 => 1, 2624 => 1,
        2625 => 1, 2626 => 20, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 20, 2634 => 20,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 40,
        2645 => 1, 2646 => 1, 2647 => 10, 2648 => 20, 2649 => 1, 2650 => 1, 2651 => 10, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 20, 2662 => 1, 2663 => 10, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 10,
        2675 => 1, 2676 => 10, 2677 => 1, 2678 => 1, 2679 => 10,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2728 => 5, 2730 => 20, 2734 => 5, 2737 => 5, 2744 => 5, 2751 => 5, 2754 => 10, 2755 => 5, 2762 => 5, 2788 => 5,
        2789 => 5, 2898 => 1, 2902 => 5},
120 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 2, 3010 => 1, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 淫具
121 => {1501 => 20, 1502 => 20, 1503 => 20, 1504 => 20, 1505 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 7, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 7, 1538 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 100, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 1, 1624 => 10,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 10, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 10, 1648 => 1, 1649 => 1, 1650 => 40, 1651 => 20, 1652 => 10, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 10, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 10, 1669 => 1, 1670 => 1, 1671 => 20, 1672 => 20, 1673 => 1, 1674 => 20,
        1675 => 40, 1676 => 20, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 12, 1701 => 12, 1702 => 12, 1703 => 12, 1704 => 12,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1733 => 5, 1745 => 5, 1748 => 20, 1750 => 10, 1759 => 5, 1770 => 10, 1773 => 5, 1783 => 5, 1899 => 10, 1898 => 40},
122 => {2000 => 2, 2003 => 2, 2004 => 2, 2005 => 2, 2006 => 2, 2007 => 2, 2008 => 2, 2009 => 1, 2010 => 2, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 2, 2052 => 1, 2055 => 2, 2056 => 2, 2057 => 2,
        2058 => 2, 2059 => 2, 2060 => 2, 2061 => 1, 2064 => 2, 2065 => 2},
123 => {2501 => 20, 2502 => 20, 2503 => 20, 2504 => 20, 2505 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 7, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 7, 2538 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 100, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 1, 2624 => 10,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 10, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 10, 2648 => 1, 2649 => 1, 2650 => 40, 2651 => 20, 2652 => 10, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 10, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 10, 2669 => 1, 2670 => 1, 2671 => 20, 2672 => 20, 2673 => 1, 2674 => 20,
        2675 => 40, 2676 => 20, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 12, 2701 => 12, 2702 => 12, 2703 => 12, 2704 => 12,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2733 => 5, 2745 => 5, 2748 => 20, 2750 => 10, 2759 => 5, 2770 => 10, 2773 => 5, 2783 => 5, 2898 => 40, 2899 => 10},
124 => {3000 => 2, 3003 => 2, 3004 => 2, 3005 => 2, 3006 => 2, 3007 => 2, 3008 => 2, 3009 => 1, 3010 => 2, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 2, 3052 => 2, 3055 => 2, 3056 => 2, 3057 => 2,
        3058 => 2, 3059 => 2, 3060 => 2, 3061 => 1},

  # 服
125 => {1509 => 20, 1511 => 20, 1513 => 20, 1514 => 20,
        1791 => 10, 1792 => 10, 1793 => 10, 1794 => 10, 1795 => 10, 1796 => 1, 1797 => 1, 1798 => 1, 1799 => 1, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1804 => 3, 1805 => 1, 1806 => 1, 1807 => 1, 1808 => 10, 1809 => 10, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 5, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8, 
        1537 => 5, 1538 => 5, 1539 => 5, 1541 => 5, 1542 => 5, 1543 => 5, 1544 => 5, 1545 => 5, 1546 => 5},
126 => {2001 => 1, 2016 => 1, 2017 => 1, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1,
        2027 => 1, 2028 => 1, 2029 => 1, 2030 => 1, 2031 => 1, 2032 => 1, 2033 => 1, 2034 => 1, 2035 => 1,
        2036 => 1}, 
127 => {2509 => 20, 2511 => 20, 2513 => 20, 2514 => 20,
        2791 => 10, 2792 => 10, 2793 => 10, 2794 => 10, 2795 => 10, 2796 => 1, 2797 => 1, 2798 => 1, 2799 => 1, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2804 => 3, 2805 => 1, 2806 => 1, 2807 => 1, 2808 => 10, 2809 => 10, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 5, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8, 
        2537 => 5, 2538 => 5, 2539 => 5, 2541 => 5, 2542 => 5, 2543 => 5, 2544 => 5, 2545 => 5, 2546 => 5},
128 => {3001 => 1, 3016 => 1, 3017 => 1, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3027 => 1, 3028 => 1, 3029 => 1, 3030 => 1, 3031 => 1, 3032 => 1, 3033 => 1, 3034 => 1, 3035 => 1,
        3036 => 1}, 

  # 武道着
129 => {1509 => 20, 1511 => 20, 1512 => 20, 1513 => 20, 1514 => 20,
        1791 => 15, 1792 => 15, 1793 => 15, 1794 => 15, 1795 => 15, 1796 => 1, 1797 => 1, 1798 => 1, 1799 => 1, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1799 => 1, 1805 => 1, 1806 => 1, 1807 => 1, 1808 => 5, 1809 => 5, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 1, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8, 
        1537 => 10, 1538 => 5, 1539 => 5, 1541 => 10, 1542 => 10, 1543 => 10, 1544 => 5, 1545 => 5, 1546 => 5},
130 => {2001 => 1, 2016 => 1, 2017 => 1, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1,
        2027 => 1, 2028 => 1, 2029 => 1, 2030 => 1, 2031 => 1, 2032 => 1, 2033 => 1, 2034 => 1, 2035 => 1,
        2036 => 1}, 
131 => {2509 => 20, 2511 => 20, 2512 => 20, 2513 => 20, 2514 => 20,
        2791 => 15, 2792 => 15, 2793 => 15, 2794 => 15, 2795 => 15, 2796 => 1, 2797 => 1, 2798 => 1, 2799 => 1, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2799 => 1, 2805 => 1, 2806 => 1, 2807 => 1, 2808 => 5, 2809 => 5, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 1, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8, 
        2537 => 10, 2538 => 5, 2539 => 5, 2541 => 10, 2542 => 10, 2543 => 10, 2544 => 5, 2545 => 5, 2546 => 5},
132 => {3001 => 1, 3016 => 1, 3017 => 1, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3027 => 1, 3028 => 1, 3029 => 1, 3030 => 1, 3031 => 1, 3032 => 1, 3033 => 1, 3034 => 1, 3035 => 1,
        3036 => 1}, 

  # 胸当て
133 => {1509 => 20, 1511 => 20, 1512 => 20, 1513 => 20, 1514 => 20,
        1791 => 5, 1792 => 5, 1793 => 5, 1794 => 5, 1795 => 5, 1796 => 1, 1797 => 1, 1798 => 1, 1799 => 1, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1799 => 1, 1805 => 1, 1806 => 1, 1807 => 5, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 1, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8, 
        1537 => 5, 1538 => 5, 1539 => 5, 1541 => 10, 1542 => 10, 1543 => 10, 1544 => 5, 1545 => 5, 1546 => 5},
134 => {2001 => 1, 2016 => 1, 2017 => 2, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1,
        2027 => 1, 2028 => 1, 2029 => 1, 2030 => 1, 2031 => 1, 2032 => 1, 2033 => 1, 2034 => 1, 2035 => 1,
        2036 => 1}, 
135 => {2509 => 20, 2511 => 20, 2512 => 20, 2513 => 20, 2514 => 20,
        2791 => 5, 2792 => 5, 2793 => 5, 2794 => 5, 2795 => 5, 2796 => 1, 2797 => 1, 2798 => 1, 2799 => 1, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2799 => 1, 2805 => 1, 2806 => 1, 2807 => 5, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 1, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8, 
        2537 => 5, 2538 => 5, 2539 => 5, 2541 => 10, 2542 => 10, 2543 => 10, 2544 => 5, 2545 => 5, 2546 => 5},
136 => {3001 => 1, 3016 => 1, 3017 => 2, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3027 => 1, 3028 => 1, 3029 => 1, 3030 => 1, 3031 => 1, 3032 => 1, 3033 => 1, 3034 => 1, 3035 => 1,
        3036 => 1}, 

  # 鎧
137 => {1509 => 20, 1511 => 20, 1513 => 20, 1514 => 20,
        1791 => 3, 1792 => 3, 1793 => 3, 1794 => 3, 1795 => 3, 1796 => 1, 1797 => 1, 1798 => 1, 1799 => 1, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1799 => 1, 1805 => 1, 1806 => 1, 1807 => 5, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 1, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8, 
        1537 => 5, 1538 => 5, 1539 => 5, 1541 => 5, 1542 => 5, 1543 => 5, 1544 => 5, 1545 => 5, 1546 => 5},
138 => {2001 => 1, 2016 => 1, 2017 => 2, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1,
        2027 => 1, 2028 => 1, 2029 => 1, 2030 => 1, 2031 => 1, 2032 => 1, 2033 => 1, 2034 => 1, 2035 => 1,
        2036 => 1}, 
139 => {2509 => 20, 2511 => 20, 2513 => 20, 2514 => 20,
        2791 => 3, 2792 => 3, 2793 => 3, 2794 => 3, 2795 => 3, 2796 => 1, 2797 => 1, 2798 => 1, 2799 => 1, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2799 => 1, 2805 => 1, 2806 => 1, 2807 => 5, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 1, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8, 
        2537 => 5, 2538 => 5, 2539 => 5, 2541 => 5, 2542 => 5, 2543 => 5, 2544 => 5, 2545 => 5, 2546 => 5},
140 => {3001 => 1, 3016 => 1, 3017 => 2, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3027 => 1, 3028 => 1, 3029 => 1, 3030 => 1, 3031 => 1, 3032 => 1, 3033 => 1, 3034 => 1, 3035 => 1,
        3036 => 1}, 

  # 重鎧
141 => {1509 => 20, 1511 => 20, 1513 => 20, 1514 => 20,
        1791 => 1, 1792 => 1, 1793 => 1, 1794 => 1, 1795 => 1, 1796 => 1, 1797 => 1, 1798 => 1, 1799 => 1, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1799 => 1, 1805 => 1, 1806 => 1, 1807 => 10, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 1, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8, 
        1537 => 10, 1538 => 5, 1539 => 5, 1541 => 5, 1542 => 5, 1543 => 5, 1544 => 5, 1545 => 5, 1546 => 5},
142 => {2001 => 1, 2016 => 1, 2017 => 3, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1,
        2027 => 1, 2028 => 1, 2029 => 1, 2030 => 1, 2031 => 1, 2032 => 1, 2033 => 1, 2034 => 1, 2035 => 1,
        2036 => 1}, 
143 => {2509 => 20, 2511 => 20, 2513 => 20, 2514 => 20,
        2791 => 1, 2792 => 1, 2793 => 1, 2794 => 1, 2795 => 1, 2796 => 1, 2797 => 1, 2798 => 1, 2799 => 1, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2799 => 1, 2805 => 1, 2806 => 1, 2807 => 10, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 1, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8, 
        2537 => 10, 2538 => 5, 2539 => 5, 2541 => 5, 2542 => 5, 2543 => 5, 2544 => 5, 2545 => 5, 2546 => 5},
144 => {3001 => 1, 3016 => 1, 3017 => 3, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3027 => 1, 3028 => 1, 3029 => 1, 3030 => 1, 3031 => 1, 3032 => 1, 3033 => 1, 3034 => 1, 3035 => 1,
        3036 => 1}, 

  # 甲羅
145 => {1509 => 20, 1511 => 20, 1512 => 20, 1513 => 20, 1514 => 20,
        1791 => 5, 1792 => 5, 1793 => 5, 1794 => 5, 1795 => 5, 1796 => 15, 1797 => 15, 1798 => 15, 1799 => 1, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1799 => 1, 1805 => 10, 1806 => 10, 1807 => 10, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 1, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8, 
        1537 => 5, 1538 => 5, 1539 => 5, 1541 => 10, 1542 => 10, 1543 => 10, 1544 => 5, 1545 => 5, 1546 => 5},
146 => {2001 => 1, 2016 => 1, 2017 => 2, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1,
        2027 => 2, 2028 => 2, 2029 => 2, 2030 => 2, 2031 => 2, 2032 => 2, 2033 => 2, 2034 => 2, 2035 => 2,
        2036 => 2}, 
147 => {2509 => 20, 2511 => 20, 2512 => 20, 2513 => 20, 2514 => 20,
        2791 => 5, 2792 => 5, 2793 => 5, 2794 => 5, 2795 => 5, 2796 => 15, 2797 => 15, 2798 => 15, 2799 => 1, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2799 => 1, 2805 => 10, 2806 => 10, 2807 => 10, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 1, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8, 
        2537 => 5, 2538 => 5, 2539 => 5, 2541 => 10, 2542 => 10, 2543 => 10, 2544 => 5, 2545 => 5, 2546 => 5},
148 => {3001 => 1, 3016 => 1, 3017 => 2, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3027 => 2, 3028 => 2, 3029 => 2, 3030 => 2, 3031 => 2, 3032 => 2, 3033 => 2, 3034 => 2, 3035 => 2,
        3036 => 2}, 

  # ローブ
149 => {1509 => 20, 1513 => 20, 1514 => 20,
        1791 => 5, 1792 => 5, 1793 => 5, 1794 => 5, 1795 => 5, 1796 => 1, 1797 => 1, 1798 => 1, 1799 => 5, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1804 => 5, 1805 => 1, 1806 => 1, 1807 => 1, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 3, 1817 => 5, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 50, 1829 => 50, 1830 => 50, 1831 => 50, 1832 => 50, 1833 => 50, 1834 => 50, 1835 => 50,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8, 
        1537 => 5, 1538 => 10, 1539 => 5, 1541 => 5, 1542 => 5, 1543 => 5, 1544 => 10, 1545 => 10, 1546 => 10,
        1594 => 30, 1595 => 30, 1596 => 30, 1597 => 30, 1598 => 30, 1599 => 30, 1600 => 30, 1601 => 30,
        1602 => 30, 1603 => 30, 1604 => 30},
150 => {2001 => 1, 2016 => 1, 2017 => 1, 2018 => 1, 2019 => 2, 2020 => 2, 2021 => 2, 2022 => 2, 2023 => 2, 2024 => 2,
        2027 => 1, 2028 => 1, 2029 => 1, 2030 => 1, 2031 => 1, 2032 => 1, 2033 => 1, 2034 => 1, 2035 => 1,
        2036 => 1}, 
151 => {2509 => 20, 2513 => 20, 2514 => 20,
        2791 => 5, 2792 => 5, 2793 => 5, 2794 => 5, 2795 => 5, 2796 => 1, 2797 => 1, 2798 => 1, 2799 => 5, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2804 => 5, 2805 => 1, 2806 => 1, 2807 => 1, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 3, 2817 => 5, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 50, 2829 => 50, 2830 => 50, 2831 => 50, 2832 => 50, 2833 => 50, 2834 => 50, 2835 => 50,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8, 
        2537 => 5, 2538 => 10, 2539 => 5, 2541 => 5, 2542 => 5, 2543 => 5, 2544 => 10, 2545 => 10, 2546 => 10,
        2594 => 30, 2595 => 30, 2596 => 30, 2597 => 30, 2598 => 30, 2599 => 30, 2600 => 30, 2601 => 30,
        2602 => 30, 2603 => 30, 2604 => 30},
152 => {3001 => 1, 3016 => 1, 3017 => 1, 3018 => 1, 3019 => 2, 3020 => 2, 3021 => 2, 3022 => 2, 3023 => 2, 3024 => 2, 
        3027 => 1, 3028 => 1, 3029 => 1, 3030 => 1, 3031 => 1, 3032 => 1, 3033 => 1, 3034 => 1, 3035 => 1,
        3036 => 1}, 

  # ドレス
153 => {1509 => 20, 1511 => 20, 1513 => 20, 
        1791 => 5, 1792 => 5, 1793 => 5, 1794 => 5, 1795 => 5, 1796 => 5, 1797 => 5, 1798 => 5, 1799 => 5, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1804 => 5, 1805 => 1, 1806 => 1, 1807 => 1, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 5, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 50, 1829 => 50, 1830 => 50, 1831 => 50, 1832 => 50, 1833 => 50, 1834 => 50, 1835 => 50,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8, 
        1537 => 10, 1538 => 10, 1539 => 5, 1541 => 10, 1542 => 10, 1543 => 10, 1544 => 10, 1545 => 10, 1546 => 10},
154 => {2001 => 1, 2016 => 1, 2017 => 1, 2018 => 2, 2019 => 2, 2020 => 2, 2021 => 2, 2022 => 2, 2023 => 2, 2024 => 2,
        2027 => 1, 2028 => 1, 2029 => 1, 2030 => 1, 2031 => 1, 2032 => 1, 2033 => 1, 2034 => 1, 2035 => 1,
        2036 => 1}, 
155 => {2509 => 20, 2511 => 20, 2513 => 20, 
        2791 => 5, 2792 => 5, 2793 => 5, 2794 => 5, 2795 => 5, 2796 => 5, 2797 => 5, 2798 => 5, 2799 => 5, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2804 => 5, 2805 => 1, 2806 => 1, 2807 => 1, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 5, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 50, 2829 => 50, 2830 => 50, 2831 => 50, 2832 => 50, 2833 => 50, 2834 => 50, 2835 => 50,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8, 
        2537 => 10, 2538 => 10, 2539 => 5, 2541 => 10, 2542 => 10, 2543 => 10, 2544 => 10, 2545 => 10, 2546 => 10},
156 => {3001 => 1, 3016 => 1, 3017 => 1, 3018 => 2, 3019 => 2, 3020 => 2, 3021 => 2, 3022 => 2, 3023 => 2, 3024 => 2, 
        3027 => 1, 3028 => 1, 3029 => 1, 3030 => 1, 3031 => 1, 3032 => 1, 3033 => 1, 3034 => 1, 3035 => 1,
        3036 => 1}, 

  # 薄着
157 => {1509 => 20, 1511 => 20,
        1791 => 15, 1792 => 15, 1793 => 15, 1794 => 15, 1795 => 15, 1796 => 10, 1797 => 10, 1798 => 10, 1799 => 5, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1804 => 5, 1805 => 1, 1806 => 1, 1807 => 1, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 5, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8, 
        1537 => 10, 1538 => 10, 1539 => 10, 1541 => 10, 1542 => 10, 1543 => 10, 1544 => 10, 1545 => 10, 1546 => 10, 1593 => 30}, 
158 => {2001 => 1, 2016 => 1, 2017 => 1, 2018 => 3, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1,
        2027 => 1, 2028 => 1, 2029 => 1, 2030 => 1, 2031 => 1, 2032 => 1, 2033 => 1, 2034 => 1, 2035 => 1,
        2036 => 1}, 
159 => {2509 => 20, 2511 => 20,
        2791 => 15, 2792 => 15, 2793 => 15, 2794 => 15, 2795 => 15, 2796 => 10, 2797 => 10, 2798 => 10, 2799 => 5, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2804 => 5, 2805 => 1, 2806 => 1, 2807 => 1, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 5, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8, 
        2537 => 10, 2538 => 10, 2539 => 10, 2541 => 10, 2542 => 10, 2543 => 10, 2544 => 10, 2545 => 10, 2546 => 10, 2593 => 30}, 
160 => {3001 => 1, 3016 => 1, 3017 => 1, 3018 => 3, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3027 => 1, 3028 => 1, 3029 => 1, 3030 => 1, 3031 => 1, 3032 => 1, 3033 => 1, 3034 => 1, 3035 => 1,
        3036 => 1}, 

  # 帽子
161 => {1517 => 20, 1519 => 20, 1521 => 20, 1522 => 20,
        1791 => 5, 1792 => 5, 1793 => 5, 1794 => 5, 1795 => 5, 1796 => 1, 1797 => 1, 1798 => 1, 1799 => 5, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1804 => 3, 1805 => 1, 1806 => 1, 1807 => 1, 1808 => 5, 1809 => 5, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 5, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 16, 1837 => 16, 1838 => 16, 1839 => 16, 1840 => 16, 1841 => 16, 1842 => 16, 1843 => 16, 1844 => 16, 1845 => 16,
        1846 => 16, 1847 => 16, 1848 => 16, 1849 => 16, 1850 => 16, 1851 => 16, 1852 => 16, 1853 => 16, 1854 => 16, 1855 => 16,
        1856 => 16, 1857 => 16, 1858 => 16, 1859 => 16, 1860 => 16, 1861 => 16, 
        1537 => 5, 1538 => 5, 1539 => 5, 1541 => 5, 1542 => 5, 1543 => 5, 1544 => 5, 1545 => 5, 1546 => 5},
162 => {2002 => 1, 2016 => 1, 2017 => 1, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1, 
        2049 => 2, 2050 => 2, 
        2053 => 1, 2062 => 1, 2063 => 1, 2067 => 1, 2069 => 1, 2070 => 1, 2071 => 1, 2072 => 1, 2074 => 1, 2076 => 1, 
        2077 => 1, 2078 => 1, 2083 => 1},
163 => {2517 => 20, 2519 => 20, 2521 => 20, 2522 => 20,
        2791 => 5, 2792 => 5, 2793 => 5, 2794 => 5, 2795 => 5, 2796 => 1, 2797 => 1, 2798 => 1, 2799 => 5, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2804 => 3, 2805 => 1, 2806 => 1, 2807 => 1, 2808 => 5, 2809 => 5, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 5, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 16, 2837 => 16, 2838 => 16, 2839 => 16, 2840 => 16, 2841 => 16, 2842 => 16, 2843 => 16, 2844 => 16, 2845 => 16,
        2846 => 16, 2847 => 16, 2848 => 16, 2849 => 16, 2850 => 16, 2851 => 16, 2852 => 16, 2853 => 16, 2854 => 16, 2855 => 16,
        2856 => 16, 2857 => 16, 2858 => 16, 2859 => 16, 2860 => 16, 2861 => 16, 
        2537 => 5, 2538 => 5, 2539 => 5, 2541 => 5, 2542 => 5, 2543 => 5, 2544 => 5, 2545 => 5, 2546 => 5},
164 => {3002 => 1, 3016 => 1, 3017 => 1, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3049 => 2, 3050 => 2, 
        3053 => 1, 3064 => 1, 3065 => 1, 3068 => 1, 3069 => 1, 3070 => 1, 3075 => 1, 3076 => 1, 3077 => 1, 3078 => 1, 
        3079 => 1, 3080 => 1, 3082 => 1, 3084 => 1},

  # 兜
165 => {1517 => 20, 1519 => 20, 1521 => 20, 1522 => 20,
        1791 => 3, 1792 => 3, 1793 => 3, 1794 => 3, 1795 => 3, 1796 => 1, 1797 => 1, 1798 => 1, 1799 => 5, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1799 => 1, 1805 => 1, 1806 => 1, 1807 => 5, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 1, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 16, 1837 => 16, 1838 => 16, 1839 => 16, 1840 => 16, 1841 => 16, 1842 => 16, 1843 => 16, 1844 => 16, 1845 => 16,
        1846 => 16, 1847 => 16, 1848 => 16, 1849 => 16, 1850 => 16, 1851 => 16, 1852 => 16, 1853 => 16, 1854 => 16, 1855 => 16,
        1856 => 16, 1857 => 16, 1858 => 16, 1859 => 16, 1860 => 16, 1861 => 16, 
        1537 => 5, 1538 => 5, 1539 => 5, 1541 => 5, 1542 => 5, 1543 => 5, 1544 => 5, 1545 => 5, 1546 => 5},
166 => {2002 => 1, 2016 => 1, 2017 => 2, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1, 
        2049 => 2, 2050 => 2, 
        2053 => 1, 2063 => 1, 2067 => 1, 2068 => 1, 2072 => 1, 2075 => 1, 2076 => 1, 2079 => 1, 2081 => 1, 2082 => 1},
167 => {2517 => 20, 2519 => 20, 2521 => 20, 2522 => 20,
        2791 => 3, 2792 => 3, 2793 => 3, 2794 => 3, 2795 => 3, 2796 => 1, 2797 => 1, 2798 => 1, 2799 => 5, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2799 => 1, 2805 => 1, 2806 => 1, 2807 => 5, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 1, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 16, 2837 => 16, 2838 => 16, 2839 => 16, 2840 => 16, 2841 => 16, 2842 => 16, 2843 => 16, 2844 => 16, 2845 => 16,
        2846 => 16, 2847 => 16, 2848 => 16, 2849 => 16, 2850 => 16, 2851 => 16, 2852 => 16, 2853 => 16, 2854 => 16, 2855 => 16,
        2856 => 16, 2857 => 16, 2858 => 16, 2859 => 16, 2860 => 16, 2861 => 16, 
        2537 => 5, 2538 => 5, 2539 => 5, 2541 => 5, 2542 => 5, 2543 => 5, 2544 => 5, 2545 => 5, 2546 => 5},
168 => {3002 => 1, 3016 => 1, 3017 => 2, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3049 => 2, 3050 => 2, 
        3053 => 1, 3054 => 1, 3067 => 1, 3068 => 1, 3070 => 1, 3078 => 1},

  # 重兜
169 => {1517 => 20, 1519 => 20, 1521 => 20, 1522 => 20,
        1791 => 1, 1792 => 1, 1793 => 1, 1794 => 1, 1795 => 1, 1796 => 1, 1797 => 1, 1798 => 1, 1799 => 5, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1799 => 1, 1805 => 1, 1806 => 1, 1807 => 10, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 1, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 16, 1837 => 16, 1838 => 16, 1839 => 16, 1840 => 16, 1841 => 16, 1842 => 16, 1843 => 16, 1844 => 16, 1845 => 16,
        1846 => 16, 1847 => 16, 1848 => 16, 1849 => 16, 1850 => 16, 1851 => 16, 1852 => 16, 1853 => 16, 1854 => 16, 1855 => 16,
        1856 => 16, 1857 => 16, 1858 => 16, 1859 => 16, 1860 => 16, 1861 => 16, 
        1537 => 10, 1538 => 5, 1539 => 5, 1541 => 5, 1542 => 5, 1543 => 5, 1544 => 5, 1545 => 5, 1546 => 5},
170 => {2002 => 1, 2016 => 1, 2017 => 3, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1, 
        2049 => 2, 2050 => 2, 
        2053 => 1, 2054 => 1, 2062 => 1, 2066 => 1, 2067 => 1, 2075 => 1, 2076 => 1, 2079 => 1},
171 => {2517 => 20, 2519 => 20, 2521 => 20, 2522 => 20,
        2791 => 1, 2792 => 1, 2793 => 1, 2794 => 1, 2795 => 1, 2796 => 1, 2797 => 1, 2798 => 1, 2799 => 5, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2799 => 1, 2805 => 1, 2806 => 1, 2807 => 10, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 1, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 16, 2837 => 16, 2838 => 16, 2839 => 16, 2840 => 16, 2841 => 16, 2842 => 16, 2843 => 16, 2844 => 16, 2845 => 16,
        2846 => 16, 2847 => 16, 2848 => 16, 2849 => 16, 2850 => 16, 2851 => 16, 2852 => 16, 2853 => 16, 2854 => 16, 2855 => 16,
        2856 => 16, 2857 => 16, 2858 => 16, 2859 => 16, 2860 => 16, 2861 => 16, 
        2537 => 10, 2538 => 5, 2539 => 5, 2541 => 5, 2542 => 5, 2543 => 5, 2544 => 5, 2545 => 5, 2546 => 5},
172 => {3002 => 1, 3016 => 1, 3017 => 3, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3049 => 2, 3050 => 2, 
        3054 => 1, 3062 => 1, 3063 => 1, 3065 => 1, 3066 => 1, 3067 => 1, 3070 => 1, 3083 => 1},

  # 魔帽
173 => {1517 => 20, 1521 => 20, 1522 => 20,
        1791 => 5, 1792 => 5, 1793 => 5, 1794 => 5, 1795 => 5, 1796 => 5, 1797 => 5, 1798 => 5, 1799 => 10, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1804 => 10, 1805 => 1, 1806 => 1, 1807 => 1, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 3, 1817 => 5, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 50, 1829 => 50, 1830 => 50, 1831 => 50, 1832 => 50, 1833 => 50, 1834 => 50, 1835 => 50,
        1836 => 16, 1837 => 16, 1838 => 16, 1839 => 16, 1840 => 16, 1841 => 16, 1842 => 16, 1843 => 16, 1844 => 16, 1845 => 16,
        1846 => 16, 1847 => 16, 1848 => 16, 1849 => 16, 1850 => 16, 1851 => 16, 1852 => 16, 1853 => 16, 1854 => 16, 1855 => 16,
        1856 => 16, 1857 => 16, 1858 => 16, 1859 => 16, 1860 => 16, 1861 => 16, 
        1537 => 5, 1538 => 10, 1539 => 5, 1541 => 5, 1542 => 5, 1543 => 5, 1544 => 5, 1545 => 5, 1546 => 5,
        1594 => 30, 1595 => 30, 1596 => 30, 1597 => 30, 1598 => 30, 1599 => 30, 1600 => 30, 1601 => 30,
        1602 => 30, 1603 => 30, 1604 => 30},
174 => {2002 => 1, 2016 => 1, 2017 => 1, 2018 => 1, 2019 => 2, 2020 => 2, 2021 => 2, 2022 => 2, 2023 => 2, 2024 => 2, 
        2049 => 2, 2050 => 2, 
        2054 => 1, 2066 => 1, 2068 => 1, 2069 => 1, 2073 => 1, 2077 => 1, 2084 => 1, 2085 => 1, 2095 => 1},
175 => {2517 => 20, 2521 => 20, 2522 => 20,
        2791 => 5, 2792 => 5, 2793 => 5, 2794 => 5, 2795 => 5, 2796 => 5, 2797 => 5, 2798 => 5, 2799 => 10, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2804 => 10, 2805 => 1, 2806 => 1, 2807 => 1, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 3, 2817 => 5, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 50, 2829 => 50, 2830 => 50, 2831 => 50, 2832 => 50, 2833 => 50, 2834 => 50, 2835 => 50,
        2836 => 16, 2837 => 16, 2838 => 16, 2839 => 16, 2840 => 16, 2841 => 16, 2842 => 16, 2843 => 16, 2844 => 16, 2845 => 16,
        2846 => 16, 2847 => 16, 2848 => 16, 2849 => 16, 2850 => 16, 2851 => 16, 2852 => 16, 2853 => 16, 2854 => 16, 2855 => 16,
        2856 => 16, 2857 => 16, 2858 => 16, 2859 => 16, 2860 => 16, 2861 => 16, 
        2537 => 5, 2538 => 10, 2539 => 5, 2541 => 5, 2542 => 5, 2543 => 5, 2544 => 5, 2545 => 5, 2546 => 5,
        2594 => 30, 2595 => 30, 2596 => 30, 2597 => 30, 2598 => 30, 2599 => 30, 2600 => 30, 2601 => 30,
        2602 => 30, 2603 => 30, 2604 => 30},
176 => {3002 => 1, 3016 => 1, 3017 => 1, 3018 => 1, 3019 => 2, 3020 => 2, 3021 => 2, 3022 => 2, 3023 => 2, 3024 => 2, 
        3049 => 2, 3050 => 2, 
        3062 => 1, 3063 => 1, 3069 => 1, 3071 => 1, 3072 => 1, 3073 => 1, 3074 => 1, 3081 => 1, 3083 => 1, 3085 => 1},

  # 高級帽
177 => {1517 => 20, 1519 => 20, 1521 => 20,
        1791 => 10, 1792 => 10, 1793 => 10, 1794 => 10, 1795 => 10, 1796 => 10, 1797 => 10, 1798 => 10, 1799 => 15, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1804 => 10, 1805 => 1, 1806 => 1, 1807 => 1, 1808 => 5, 1809 => 5, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 5, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 1,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 16, 1837 => 16, 1838 => 16, 1839 => 16, 1840 => 16, 1841 => 16, 1842 => 16, 1843 => 16, 1844 => 16, 1845 => 16,
        1846 => 16, 1847 => 16, 1848 => 16, 1849 => 16, 1850 => 16, 1851 => 16, 1852 => 16, 1853 => 16, 1854 => 16, 1855 => 16,
        1856 => 16, 1857 => 16, 1858 => 16, 1859 => 16, 1860 => 16, 1861 => 16, 
        1537 => 10, 1538 => 10, 1539 => 10, 1541 => 5, 1542 => 5, 1543 => 5, 1544 => 10, 1545 => 10, 1546 => 10, 1593 => 30}, 
178 => {2002 => 1, 2016 => 1, 2017 => 1, 2018 => 2, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1, 
        2049 => 3, 2050 => 3, 
        2054 => 1, 2062 => 1, 2069 => 1, 2070 => 1, 2071 => 1, 2072 => 1, 2073 => 1, 2074 => 1, 2078 => 1, 2080 => 1, 
        2081 => 1, 2082 => 1, 2083 => 1, 2084 => 1, 2085 => 1, 2095 => 1},
179 => {2517 => 20, 2519 => 20, 2521 => 20,
        2791 => 10, 2792 => 10, 2793 => 10, 2794 => 10, 2795 => 10, 2796 => 10, 2797 => 10, 2798 => 10, 2799 => 15, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2804 => 10, 2805 => 1, 2806 => 1, 2807 => 1, 2808 => 5, 2809 => 5, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 5, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 1,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 16, 2837 => 16, 2838 => 16, 2839 => 16, 2840 => 16, 2841 => 16, 2842 => 16, 2843 => 16, 2844 => 16, 2845 => 16,
        2846 => 16, 2847 => 16, 2848 => 16, 2849 => 16, 2850 => 16, 2851 => 16, 2852 => 16, 2853 => 16, 2854 => 16, 2855 => 16,
        2856 => 16, 2857 => 16, 2858 => 16, 2859 => 16, 2860 => 16, 2861 => 16, 
        2537 => 10, 2538 => 10, 2539 => 10, 2541 => 5, 2542 => 5, 2543 => 5, 2544 => 10, 2545 => 10, 2546 => 10, 2593 => 30}, 
180 => {3002 => 1, 3016 => 1, 3017 => 1, 3018 => 2, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3049 => 3, 3050 => 3, 
        3053 => 1, 3062 => 1, 3063 => 1, 3064 => 1, 3065 => 1, 3066 => 1, 3068 => 1, 3069 => 1, 3071 => 1, 3072 => 1, 
        3073 => 1, 3074 => 1, 3075 => 1, 3076 => 1, 3077 => 1, 3078 => 1, 3079 => 1, 3080 => 1, 3081 => 1, 3082 => 1, 
        3084 => 1, 3085 => 1},

  # 軽盾
181 => {1517 => 20, 1519 => 20, 1521 => 20, 1522 => 20, 1617 => 20, 1736 => 5, 
        1791 => 15, 1792 => 15, 1793 => 15, 1794 => 15, 1795 => 15, 1796 => 5, 1797 => 5, 1798 => 5, 1799 => 5, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1799 => 1, 1805 => 5, 1806 => 5, 1807 => 5, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 1, 1817 => 1, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 5,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8,
        1537 => 5, 1538 => 5, 1539 => 5, 1541 => 5, 1542 => 5, 1543 => 5, 1544 => 5, 1545 => 5, 1546 => 5},
182 => {2002 => 1, 2016 => 1, 2017 => 1, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1, 
        2037 => 2, 2038 => 2, 2039 => 2, 2040 => 2, 2041 => 2, 2042 => 2, 2043 => 2, 2044 => 2, 2045 => 2,
        2046 => 2, 2047 => 2, 2048 => 2}, 
183 => {2517 => 20, 2519 => 20, 2521 => 20, 2522 => 20, 2617 => 20, 2736 => 5, 
        2791 => 15, 2792 => 15, 2793 => 15, 2794 => 15, 2795 => 15, 2796 => 5, 2797 => 5, 2798 => 5, 2799 => 5, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2799 => 1, 2805 => 5, 2806 => 5, 2807 => 5, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 1, 2817 => 1, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 5,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8,
        2537 => 5, 2538 => 5, 2539 => 5, 2541 => 5, 2542 => 5, 2543 => 5, 2544 => 5, 2545 => 5, 2546 => 5},
184 => {3002 => 1, 3016 => 1, 3017 => 1, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3037 => 2, 3038 => 2, 3039 => 2, 3040 => 2, 3041 => 2, 3042 => 2, 3043 => 2, 3044 => 2, 3045 => 2,
        3046 => 2, 3047 => 2, 3048 => 2}, 

  # 盾
185 => {1517 => 20, 1519 => 20, 1521 => 20, 1522 => 20, 1617 => 20, 1736 => 5, 
        1791 => 10, 1792 => 10, 1793 => 10, 1794 => 10, 1795 => 10, 1796 => 10, 1797 => 10, 1798 => 10, 1799 => 5, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1799 => 1, 1805 => 5, 1806 => 5, 1807 => 10, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 1, 1817 => 1, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 10,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8,
        1537 => 5, 1538 => 5, 1539 => 5, 1541 => 5, 1542 => 5, 1543 => 5, 1544 => 5, 1545 => 5, 1546 => 5},
186 => {2002 => 1, 2016 => 1, 2017 => 2, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1, 
        2037 => 2, 2038 => 2, 2039 => 2, 2040 => 2, 2041 => 2, 2042 => 2, 2043 => 2, 2044 => 2, 2045 => 2,
        2046 => 2, 2047 => 2, 2048 => 2}, 
187 => {2517 => 20, 2519 => 20, 2521 => 20, 2522 => 20, 2617 => 20, 2736 => 5, 
        2791 => 10, 2792 => 10, 2793 => 10, 2794 => 10, 2795 => 10, 2796 => 10, 2797 => 10, 2798 => 10, 2799 => 5, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2799 => 1, 2805 => 5, 2806 => 5, 2807 => 10, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 1, 2817 => 1, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 10,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8,
        2537 => 5, 2538 => 5, 2539 => 5, 2541 => 5, 2542 => 5, 2543 => 5, 2544 => 5, 2545 => 5, 2546 => 5},
188 => {3002 => 1, 3016 => 1, 3017 => 2, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3037 => 2, 3038 => 2, 3039 => 2, 3040 => 2, 3041 => 2, 3042 => 2, 3043 => 2, 3044 => 2, 3045 => 2,
        3046 => 2, 3047 => 2, 3048 => 2}, 

  # 重盾
189 => {1517 => 20, 1519 => 20, 1521 => 20, 1522 => 20, 1617 => 20, 1736 => 5, 
        1791 => 5, 1792 => 5, 1793 => 5, 1794 => 5, 1795 => 5, 1796 => 15, 1797 => 15, 1798 => 15, 1799 => 5, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1799 => 1, 1805 => 5, 1806 => 5, 1807 => 15, 1808 => 1, 1809 => 1, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 1, 1817 => 1, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 15,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8,
        1537 => 10, 1538 => 5, 1539 => 5, 1541 => 5, 1542 => 5, 1543 => 5, 1544 => 5, 1545 => 5, 1546 => 5},
190 => {2002 => 1, 2016 => 1, 2017 => 3, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1, 
        2037 => 2, 2038 => 2, 2039 => 2, 2040 => 2, 2041 => 2, 2042 => 2, 2043 => 2, 2044 => 2, 2045 => 2,
        2046 => 2, 2047 => 2, 2048 => 2}, 
191 => {2517 => 20, 2519 => 20, 2521 => 20, 2522 => 20, 2617 => 20, 2736 => 5, 
        2791 => 5, 2792 => 5, 2793 => 5, 2794 => 5, 2795 => 5, 2796 => 15, 2797 => 15, 2798 => 15, 2799 => 5, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2799 => 1, 2805 => 5, 2806 => 5, 2807 => 15, 2808 => 1, 2809 => 1, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 1, 2817 => 1, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 15,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8,
        2537 => 10, 2538 => 5, 2539 => 5, 2541 => 5, 2542 => 5, 2543 => 5, 2544 => 5, 2545 => 5, 2546 => 5},
192 => {3002 => 1, 3016 => 1, 3017 => 3, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3037 => 2, 3038 => 2, 3039 => 2, 3040 => 2, 3041 => 2, 3042 => 2, 3043 => 2, 3044 => 2, 3045 => 2,
        3046 => 2, 3047 => 2, 3048 => 2}, 

  # アクセサリ
193 => {1517 => 20, 1518 => 20, 1519 => 20, 1520 => 20, 1521 => 20, 1522 => 20, 
        1526 => 7, 1527 => 7, 1528 => 7, 1529 => 7, 1530 => 7, 1531 => 7, 1532 => 7, 1533 => 7, 1534 => 7, 1535 => 7,
        1536 => 7, 1537 => 7, 1538 => 7, 1539 => 7, 1540 => 7, 1541 => 7, 1542 => 7, 1543 => 7, 1544 => 7, 1545 => 7,
        1546 => 7, 1547 => 7, 1548 => 2, 1549 => 7, 1550 => 7, 1551 => 7, 1552 => 7,
        1553 => 3, 1554 => 3, 1555 => 3, 1556 => 3, 1557 => 3, 1558 => 3, 1559 => 3, 1560 => 3, 1561 => 3, 1562 => 3,
        1563 => 3, 1564 => 3, 1565 => 3, 1566 => 3, 1567 => 3, 1568 => 3, 1569 => 3, 1570 => 3, 1571 => 3, 1572 => 3,
        1573 => 3, 1574 => 3, 1575 => 3, 1576 => 3, 1577 => 3, 1578 => 3, 1579 => 3, 1580 => 3, 1581 => 3, 1582 => 3,
        1583 => 3, 1584 => 3, 1585 => 3, 1586 => 3, 1587 => 3, 1588 => 3, 1589 => 3, 1590 => 3, 1591 => 3, 1592 => 3,
        1593 => 10, 1594 => 10, 1595 => 10, 1596 => 10, 1597 => 10, 1598 => 10, 1599 => 10, 1600 => 10, 1601 => 10,
        1602 => 10, 1603 => 10, 1604 => 10,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 1, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1666 => 1, 1667 => 1, 1668 => 1, 1669 => 1, 1670 => 1, 1671 => 1, 1672 => 1, 1673 => 1, 1674 => 1,
        1675 => 1, 1676 => 1, 1677 => 1, 1678 => 1, 1679 => 1,
        1680 => 4, 1681 => 4, 1682 => 4, 1683 => 4, 1684 => 4, 1685 => 4, 1686 => 4, 1687 => 4, 1688 => 4, 1689 => 4,
        1690 => 4, 1691 => 4, 1692 => 4, 1693 => 4, 1694 => 4, 1695 => 4, 1696 => 4, 1697 => 4, 1698 => 4, 1699 => 4,
        1700 => 4, 1701 => 4, 1702 => 4, 1703 => 4, 1704 => 4,
        1705 => 10, 1706 => 10, 1707 => 10, 1708 => 10, 1709 => 10,
        1791 => 5, 1792 => 5, 1793 => 5, 1794 => 5, 1795 => 5, 1796 => 5, 1797 => 5, 1798 => 5, 1799 => 5, 1800 => 5,
        1801 => 5, 1802 => 5, 1803 => 5, 1804 => 5, 1805 => 5, 1806 => 5, 1807 => 5, 1808 => 5, 1809 => 5, 1810 => 5,
        1811 => 5, 1812 => 5, 1813 => 5, 1814 => 5, 1815 => 5, 1816 => 5, 1817 => 5, 1818 => 5, 1819 => 5, 1820 => 5,
        1821 => 5, 1822 => 5, 1823 => 5, 1824 => 5, 1825 => 5, 1826 => 5, 1827 => 5,
        1828 => 20, 1829 => 20, 1830 => 20, 1831 => 20, 1832 => 20, 1833 => 20, 1834 => 20, 1835 => 20,
        1836 => 8, 1837 => 8, 1838 => 8, 1839 => 8, 1840 => 8, 1841 => 8, 1842 => 8, 1843 => 8, 1844 => 8, 1845 => 8,
        1846 => 8, 1847 => 8, 1848 => 8, 1849 => 8, 1850 => 8, 1851 => 8, 1852 => 8, 1853 => 8, 1854 => 8, 1855 => 8,
        1856 => 8, 1857 => 8, 1858 => 8, 1859 => 8, 1860 => 8, 1861 => 8, 1862 => 8,
        1863 => 1, 1864 => 1, 1865 => 1, 1866 => 1, 1867 => 1, 1868 => 1, 1869 => 1, 1870 => 1, 1871 => 1, 1872 => 1,
        1873 => 1, 1874 => 1, 1875 => 1, 1876 => 1, 1877 => 1, 1878 => 1, 1879 => 1, 1880 => 1, 1881 => 1, 1882 => 1,
        1883 => 1, 1884 => 1, 1885 => 1, 1886 => 1, 1887 => 1, 1888 => 1, 1889 => 1, 1890 => 1, 1891 => 1, 1892 => 1,
        1893 => 1, 1894 => 1, 1895 => 1, 1896 => 1, 1898 => 1},
194 => {2002 => 1, 2003 => 1, 2004 => 1, 2005 => 1, 2006 => 1, 2007 => 1, 2008 => 1, 2009 => 1, 2010 => 1, 2011 => 1,
        2012 => 1, 2013 => 1, 2051 => 1, 2052 => 1, 2055 => 1, 2056 => 1, 2057 => 1,
        2058 => 1, 2059 => 1, 2060 => 1, 2061 => 1, 2064 => 1, 2065 => 1,
        2016 => 1, 2017 => 1, 2018 => 1, 2019 => 1, 2020 => 1, 2021 => 1, 2022 => 1, 2023 => 1, 2024 => 1,
        2027 => 1, 2028 => 1, 2029 => 1, 2030 => 1, 2031 => 1, 2032 => 1, 2033 => 1, 2034 => 1, 2035 => 1,
        2036 => 1, 2037 => 1, 2038 => 1, 2039 => 1, 2040 => 1, 2041 => 1, 2042 => 1, 2043 => 1, 2044 => 1, 2045 => 1,
        2046 => 1, 2047 => 1, 2048 => 1, 2049 => 1, 2050 => 1, 
        2086 => 2, 2087 => 2, 2088 => 2, 2089 => 2, 2090 => 2, 2091 => 2, 2092 => 2, 2093 => 2, 2094 => 2, 2095 => 2},
195 => {2517 => 20, 2518 => 20, 2519 => 20, 2520 => 20, 2521 => 20, 2522 => 20, 
        2526 => 7, 2527 => 7, 2528 => 7, 2529 => 7, 2530 => 7, 2531 => 7, 2532 => 7, 2533 => 7, 2534 => 7, 2535 => 7,
        2536 => 7, 2537 => 7, 2538 => 7, 2539 => 7, 2540 => 7, 2541 => 7, 2542 => 7, 2543 => 7, 2544 => 7, 2545 => 7,
        2546 => 7, 2547 => 7, 2548 => 2, 2549 => 7, 2550 => 7, 2551 => 7, 2552 => 7,
        2553 => 3, 2554 => 3, 2555 => 3, 2556 => 3, 2557 => 3, 2558 => 3, 2559 => 3, 2560 => 3, 2561 => 3, 2562 => 3,
        2563 => 3, 2564 => 3, 2565 => 3, 2566 => 3, 2567 => 3, 2568 => 3, 2569 => 3, 2570 => 3, 2571 => 3, 2572 => 3,
        2573 => 3, 2574 => 3, 2575 => 3, 2576 => 3, 2577 => 3, 2578 => 3, 2579 => 3, 2580 => 3, 2581 => 3, 2582 => 3,
        2583 => 3, 2584 => 3, 2585 => 3, 2586 => 3, 2587 => 3, 2588 => 3, 2589 => 3, 2590 => 3, 2591 => 3, 2592 => 3,
        2593 => 10, 2594 => 10, 2595 => 10, 2596 => 10, 2597 => 10, 2598 => 10, 2599 => 10, 2600 => 10, 2601 => 10,
        2602 => 10, 2603 => 10, 2604 => 10,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 1, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2666 => 1, 2667 => 1, 2668 => 1, 2669 => 1, 2670 => 1, 2671 => 1, 2672 => 1, 2673 => 1, 2674 => 1,
        2675 => 1, 2676 => 1, 2677 => 1, 2678 => 1, 2679 => 1,
        2680 => 4, 2681 => 4, 2682 => 4, 2683 => 4, 2684 => 4, 2685 => 4, 2686 => 4, 2687 => 4, 2688 => 4, 2689 => 4,
        2690 => 4, 2691 => 4, 2692 => 4, 2693 => 4, 2694 => 4, 2695 => 4, 2696 => 4, 2697 => 4, 2698 => 4, 2699 => 4,
        2700 => 4, 2701 => 4, 2702 => 4, 2703 => 4, 2704 => 4,
        2705 => 10, 2706 => 10, 2707 => 10, 2708 => 10, 2709 => 10,
        2791 => 5, 2792 => 5, 2793 => 5, 2794 => 5, 2795 => 5, 2796 => 5, 2797 => 5, 2798 => 5, 2799 => 5, 2800 => 5,
        2801 => 5, 2802 => 5, 2803 => 5, 2804 => 5, 2805 => 5, 2806 => 5, 2807 => 5, 2808 => 5, 2809 => 5, 2810 => 5,
        2811 => 5, 2812 => 5, 2813 => 5, 2814 => 5, 2815 => 5, 2816 => 5, 2817 => 5, 2818 => 5, 2819 => 5, 2820 => 5,
        2821 => 5, 2822 => 5, 2823 => 5, 2824 => 5, 2825 => 5, 2826 => 5, 2827 => 5,
        2828 => 20, 2829 => 20, 2830 => 20, 2831 => 20, 2832 => 20, 2833 => 20, 2834 => 20, 2835 => 20,
        2836 => 8, 2837 => 8, 2838 => 8, 2839 => 8, 2840 => 8, 2841 => 8, 2842 => 8, 2843 => 8, 2844 => 8, 2845 => 8,
        2846 => 8, 2847 => 8, 2848 => 8, 2849 => 8, 2850 => 8, 2851 => 8, 2852 => 8, 2853 => 8, 2854 => 8, 2855 => 8,
        2856 => 8, 2857 => 8, 2858 => 8, 2859 => 8, 2860 => 8, 2861 => 8, 2862 => 8,
        2863 => 1, 2864 => 1, 2865 => 1, 2866 => 1, 2867 => 1, 2868 => 1, 2869 => 1, 2870 => 1, 2871 => 1, 2872 => 1,
        2873 => 1, 2874 => 1, 2875 => 1, 2876 => 1, 2877 => 1, 2878 => 1, 2879 => 1, 2880 => 1, 2881 => 1, 2882 => 1,
        2883 => 1, 2884 => 1, 2885 => 1, 2886 => 1, 2887 => 1, 2888 => 1, 2889 => 1, 2890 => 1, 2891 => 1, 2892 => 1,
        2893 => 1, 2894 => 1, 2895 => 1, 2896 => 1, 2898 => 1},
196 => {3002 => 1, 3003 => 1, 3004 => 1, 3005 => 1, 3006 => 1, 3007 => 1, 3008 => 1, 3009 => 1, 3010 => 1, 3011 => 1,
        3012 => 1, 3013 => 1, 3051 => 1, 3052 => 1, 3055 => 1, 3056 => 1, 3057 => 1,
        3058 => 1, 3059 => 1, 3060 => 1, 3061 => 1,
        3016 => 1, 3017 => 1, 3018 => 1, 3019 => 1, 3020 => 1, 3021 => 1, 3022 => 1, 3023 => 1, 3024 => 1, 
        3027 => 1, 3028 => 1, 3029 => 1, 3030 => 1, 3031 => 1, 3032 => 1, 3033 => 1, 3034 => 1, 3035 => 1,
        3036 => 1, 3037 => 1, 3038 => 1, 3039 => 1, 3040 => 1, 3041 => 1, 3042 => 1, 3043 => 1, 3044 => 1, 3045 => 1,
        3046 => 1, 3047 => 1, 3048 => 1, 3049 => 1, 3050 => 1,
        3086 => 2, 3087 => 2, 3088 => 2, 3089 => 2, 3090 => 2, 3091 => 2, 3092 => 2, 3093 => 2, 3094 => 2, 3095 => 2},

  # レア防具
200 => {1593 => 3, 1594 => 3, 1595 => 3, 1596 => 3, 1597 => 3, 1598 => 3, 1599 => 3, 1600 => 3, 1601 => 3,
        1602 => 3, 1603 => 3, 1604 => 3,
        1605 => 1, 1606 => 1, 1607 => 1, 1608 => 1, 1609 => 1, 1610 => 1, 1611 => 1, 1612 => 1, 1613 => 1, 1614 => 1,
        1615 => 1, 1616 => 1, 1617 => 1, 1618 => 1, 1619 => 1, 1620 => 1, 1621 => 1, 1622 => 1, 1623 => 1, 1624 => 1,
        1625 => 1, 1626 => 1, 1627 => 1, 1628 => 1, 1629 => 1, 1630 => 1, 1631 => 1, 1632 => 1, 1633 => 1, 1634 => 1,
        1635 => 1, 1636 => 1, 1637 => 1, 1638 => 1, 1639 => 1, 1640 => 1, 1641 => 1, 1642 => 1, 1643 => 1, 1644 => 1,
        1645 => 1, 1646 => 1, 1647 => 1, 1648 => 1, 1649 => 1, 1650 => 1, 1651 => 1, 1652 => 1, 1653 => 1, 1654 => 1,
        1655 => 1, 1656 => 1, 1657 => 1, 1658 => 1, 1659 => 1, 1660 => 1, 1661 => 1, 1662 => 1, 1663 => 1, 1664 => 1,
        1665 => 1, 1898 => 1},
201 => {2593 => 3, 2594 => 3, 2595 => 3, 2596 => 3, 2597 => 3, 2598 => 3, 2599 => 3, 2600 => 3, 2601 => 3,
        2602 => 3, 2603 => 3, 2604 => 3,
        2605 => 1, 2606 => 1, 2607 => 1, 2608 => 1, 2609 => 1, 2610 => 1, 2611 => 1, 2612 => 1, 2613 => 1, 2614 => 1,
        2615 => 1, 2616 => 1, 2617 => 1, 2618 => 1, 2619 => 1, 2620 => 1, 2621 => 1, 2622 => 1, 2623 => 1, 2624 => 1,
        2625 => 1, 2626 => 1, 2627 => 1, 2628 => 1, 2629 => 1, 2630 => 1, 2631 => 1, 2632 => 1, 2633 => 1, 2634 => 1,
        2635 => 1, 2636 => 1, 2637 => 1, 2638 => 1, 2639 => 1, 2640 => 1, 2641 => 1, 2642 => 1, 2643 => 1, 2644 => 1,
        2645 => 1, 2646 => 1, 2647 => 1, 2648 => 1, 2649 => 1, 2650 => 1, 2651 => 1, 2652 => 1, 2653 => 1, 2654 => 1,
        2655 => 1, 2656 => 1, 2657 => 1, 2658 => 1, 2659 => 1, 2660 => 1, 2661 => 1, 2662 => 1, 2663 => 1, 2664 => 1,
        2665 => 1, 2898 => 1},

  # 短剣技
202 => {3501 => 1, 3502 => 1, 3503 => 1, 4194 => 3, 4195 => 3, 4196 => 3, 4197 => 3},

  # 剣技
203 => {3505 => 1, 3506 => 1, 3507 => 1, 3508 => 1, 3509 => 1, 3510 => 1, 3511 => 1, 3512 => 1, 3513 => 1, 3514 => 1, 3515 => 1, 
        3516 => 1, 3517 => 1, 3518 => 1, 3519 => 1, 3520 => 1, 3521 => 1, 3522 => 1, 3524 => 1, 3525 => 1, 3526 => 1, 
        3527 => 1, 3528 => 1, 3529 => 1, 3535 => 1, 4164 => 2, 4198 => 3, 4199 => 3, 4200 => 3, 4201 => 3},

  # 尖剣技
204 => {3538 => 1, 3539 => 1, 3540 => 1, 3541 => 1, 3542 => 1, 3543 => 1, 3544 => 1, 4405 => 1, 4202 => 3, 4203 => 3, 4204 => 3, 4205 => 3, 4421 => 1},

  # 刀技
205 => {3546 => 1, 3547 => 1, 3548 => 1, 3549 => 1, 3550 => 1, 3551 => 1, 3552 => 1, 3553 => 1, 3554 => 1, 3555 => 1, 
        3556 => 1, 3557 => 1, 3558 => 1, 3560 => 1, 4206 => 3, 4207 => 3, 4208 => 3, 4209 => 3},

  # 槍技
206 => {3563 => 1, 3564 => 1, 3565 => 1, 3566 => 1, 3567 => 1, 3568 => 1, 3569 => 1, 3570 => 1, 3571 => 1, 3572 => 1, 3573 => 1, 
        3574 => 1, 3575 => 1, 3576 => 1, 3577 => 1, 3578 => 1, 3579 => 1, 3580 => 1, 3581 => 1, 4165 => 2, 4210 => 3, 4211 => 3, 4212 => 3, 4213 => 3},

  # 斧技
207 => {3583 => 1, 3584 => 1, 3585 => 1, 3586 => 1, 3587 => 1, 3588 => 1, 3589 => 1, 3590 => 1, 3591 => 1, 4214 => 3, 4215 => 3},

  # 棍技
208 => {3593 => 1, 3594 => 1, 3595 => 1, 3596 => 1, 3597 => 1, 3598 => 1, 3599 => 1, 3600 => 1, 3601 => 1, 3602 => 1, 4216 => 3, 4217 => 3, 4218 => 3, 4219 => 3},

  # 鎌技
209 => {3605 => 1, 3606 => 1, 3607 => 1, 3608 => 1, 3609 => 1, 3610 => 1, 3611 => 1, 4220 => 3, 4221 => 3, 4222 => 3, 4223 => 3},

  # 弓技
210 => {3614 => 1, 3615 => 1, 3616 => 1, 3617 => 1, 3618 => 1, 3619 => 1, 3620 => 1, 3621 => 1, 3622 => 1, 3623 => 1, 
        3624 => 1, 3625 => 1, 3626 => 1, 4166 => 2, 4224 => 3, 4225 => 3, 4226 => 3, 4227 => 3},

  # 鞭技
211 => {3629 => 1, 3630 => 1, 3631 => 1, 3632 => 1, 3633 => 1, 3634 => 1, 3635 => 1, 3636 => 1, 4406 => 1, 4228 => 3, 4229 => 3, 4230 => 3},

  # 投擲技
212 => {3638 => 1, 3639 => 1, 3640 => 1, 3641 => 1, 3642 => 1, 3643 => 1, 4231 => 3, 4232 => 3, 4233 => 3, 4234 => 3},

  # 鉄球技
213 => {3646 => 1, 3647 => 1, 3648 => 1, 3649 => 1, 3650 => 1, 3651 => 1, 3652 => 1, 3653 => 1, 3654 => 1, 4235 => 3, 4236 => 3, 4237 => 3},

  # 扇技
214 => {3656 => 1, 3657 => 1, 3658 => 1, 3659 => 1, 3660 => 1, 3661 => 1, 3662 => 1, 3663 => 1, 3664 => 1, 3666 => 1, 4407 => 1, 4238 => 3, 4239 => 3, 4240 => 3, 4241 => 3},

  # 銃技
215 => {3669 => 1, 3670 => 1, 3671 => 1, 3672 => 1, 3673 => 1, 3674 => 1, 3675 => 1, 3676 => 1, 3679 => 1, 4167 => 2, 4242 => 3, 4243 => 3, 4244 => 3, 4245 => 3},

  # 多武器技
216 => {3680 => 1, 3684 => 1, 3685 => 1, 3686 => 1, 3688 => 1, 4246 => 3},

  # 格闘
217 => {3691 => 1, 3692 => 1, 3693 => 1, 3694 => 1, 3695 => 1, 3696 => 1, 3697 => 1, 3698 => 1, 3699 => 1, 3700 => 1, 
        3701 => 1, 3702 => 1, 3703 => 1, 3704 => 1, 3705 => 1, 3710 => 1, 3711 => 1, 3712 => 1, 3713 => 1, 3715 => 1, 4168 => 2, 4247 => 3, 4248 => 3, 4249 => 3, 4250 => 3},

  # 白魔法
218 => {3716 => 1, 4169 => 3, 4251 => 3, 4252 => 3},

  # 黒魔法
219 => {3717 => 1, 3718 => 1, 3719 => 1, 3720 => 1, 3721 => 1, 3722 => 1, 3723 => 1, 3724 => 1, 3725 => 1, 3726 => 1, 
        3727 => 1, 3728 => 1, 3729 => 1, 3731 => 1, 4156 => 1, 4157 => 1, 4158 => 1, 4159 => 1, 4170 => 1, 4253 => 3, 4254 => 3, 4255 => 3, 4256 => 3},

  # 時魔法
220 => {3732 => 1, 3733 => 1, 3734 => 1, 4257 => 3},

  # 召喚
221 => {3737 => 1, 3738 => 1, 3739 => 1, 3740 => 1, 3741 => 1, 3742 => 1, 3743 => 1, 3744 => 1, 3745 => 1, 3746 => 1, 
        3747 => 1, 3748 => 1, 3749 => 1, 3752 => 1, 3753 => 1, 4258 => 3, 4259 => 3, 4260 => 3, 4261 => 3},

  # 召喚（ゾンビ）
222 => {3755 => 1, 3756 => 1, 3757 => 1, 3758 => 1, 3759 => 1, 4258 => 3, 4259 => 3, 4260 => 3, 4261 => 3},

  # 召喚（ゴースト）
223 => {3760 => 1, 3761 => 1, 3762 => 1, 3763 => 1, 3764 => 1, 4171 => 1, 4258 => 3, 4259 => 3, 4260 => 3, 4261 => 3},

  # 召喚（からくり）
224 => {3765 => 1, 3766 => 1, 3767 => 1, 3768 => 1, 3769 => 1, 4258 => 3, 4259 => 3, 4260 => 3, 4261 => 3},

  # 聖技
225 => {3773 => 1, 3774 => 1, 3775 => 1, 3776 => 1, 3777 => 1, 3778 => 1, 3779 => 1, 3780 => 1, 3781 => 1, 3784 => 1, 
        3787 => 1, 3788 => 1, 3789 => 1, 3790 => 1, 3791 => 1, 4172 => 2, 4262 => 3, 4263 => 3, 4264 => 3, 4265 => 3},

  # 闇技
226 => {3792 => 1, 3793 => 1, 3794 => 1, 3795 => 1, 3796 => 1, 3798 => 1, 3799 => 1, 3800 => 1, 4266 => 3},

  # 陰陽術
227 => {3812 => 1, 3813 => 1, 3814 => 1, 3815 => 1, 3816 => 1, 3817 => 1, 3818 => 1, 4160 => 1, 4161 => 1, 4162 => 1, 4173 => 1, 4267 => 3, 4268 => 3, 4269 => 3},

  # 盗賊技
228 => {3821 => 1},

  # 忍術
229 => {3822 => 1, 3823 => 1, 3824 => 1, 3825 => 1, 3826 => 1, 3827 => 1, 3828 => 1, 3829 => 1, 3830 => 1, 3831 => 1, 
        3834 => 1, 3835 => 1, 3836 => 1, 3837 => 1, 4174 => 1, 4270 => 3, 4271 => 3, 4272 => 3},

  # 海賊技
230 => {3838 => 1, 3839 => 1, 3840 => 1, 3841 => 1, 3842 => 1, 3843 => 1, 3844 => 1, 3845 => 1, 3846 => 1, 3847 => 1, 4273 => 3, 4274 => 3, 4275 => 3},

  # ヒーロー技
231 => {3848 => 1, 3849 => 1, 3850 => 1, 3851 => 1, 4175 => 1, 4276 => 3},

  # オラクル
232 => {3855 => 1, 3856 => 1, 4176 => 1, 4278 => 3, 4279 => 3},

  # 踊る
233 => {3857 => 1, 3858 => 1, 3859 => 1, 3860 => 1, 3861 => 1, 3862 => 1, 3863 => 1, 3864 => 1, 4409 => 1, 4177 => 3, 4280 => 3, 4281 => 3},

  # 歌う
234 => {3867 => 1, 3868 => 1, 3870 => 1, 3871 => 1, 4282 => 3},

  # 話す
235 => {3872 => 1, 4178 => 2},

  # 魔導科学
236 => {3873 => 1, 3874 => 1, 3875 => 1, 3876 => 1, 3877 => 1, 4283 => 3, 4284 => 3, 4285 => 3},

  # 魔本術・錬金術
237 => {3878 => 1, 3879 => 1, 3880 => 1, 3881 => 1, 3882 => 1, 4145 => 1, 4179 => 1, 4180 => 1, 4286 => 3, 4287 => 3},

  # マキナ
238 => {3883 => 1, 3884 => 1, 3885 => 1, 3886 => 1, 3887 => 1, 3888 => 1, 3890 => 1, 3891 => 1, 4288 => 3, 4289 => 3, 4290 => 3, 4291 => 3},

  # 医術
239 => {3892 => 1, 3893 => 1, 3894 => 1, 4182 => 3, 4295 => 3, 4296 => 3, 4297 => 3},

  # 御奉仕
240 => {3895 => 1, 3896 => 1, 3897 => 1, 3898 => 1, 3900 => 1, 3901 => 1, 3902 => 1, 3903 => 1, 4183 => 3, 4298 => 3, 4299 => 3, 4300 => 3, 4301 => 3},

  # 王技（剣）
241 => {3904 => 1, 3912 => 1, 4302 => 3, 4303 => 3},

  # 王技（魔法）
242 => {3907 => 1, 3908 => 1, 3914 => 1, 4184 => 2, 4302 => 3, 4303 => 3},

  # 勇者技
243 => {3917 => 1, 3918 => 1, 3919 => 1, 3920 => 1, 3921 => 1, 3922 => 1, 3923 => 1, 3928 => 1, 4304 => 3, 4305 => 3, 4306 => 3, 4307 => 3},

  # 淫技
244 => {3931 => 1, 3932 => 1, 3933 => 1, 3934 => 1, 3935 => 1, 3936 => 1, 3937 => 1, 3938 => 1, 3939 => 1, 3940 => 1, 
        3941 => 1, 3942 => 1, 3943 => 1, 3944 => 1, 3945 => 1, 3946 => 1, 3947 => 1, 3948 => 1, 3950 => 1, 3951 => 1, 
        3952 => 1, 4308 => 3, 4309 => 3, 4310 => 3, 4311 => 3},

  # 魔技
245 => {3954 => 1, 3955 => 1, 3956 => 1, 3958 => 1, 3960 => 1, 3961 => 1, 3963 => 1, 3964 => 1, 3965 => 1, 3967 => 1, 
        3970 => 1, 3971 => 1, 3972 => 1, 3973 => 1, 3974 => 1, 3975 => 1, 3976 => 1, 3977 => 1, 3978 => 1, 3980 => 1, 
        3981 => 1, 4185 => 2, 4312 => 3, 4313 => 3, 4314 => 3, 4315 => 3},

  # 海技
246 => {3982 => 1, 3983 => 1, 3984 => 1, 3985 => 1, 3986 => 1, 3989 => 1, 3990 => 1, 3991 => 1, 3992 => 1, 4140 => 1, 
        4141 => 1, 4142 => 1, 4186 => 3, 4316 => 3, 4317 => 3, 4318 => 3, 4319 => 3},

  # 粘液技
247 => {3993 => 1, 3994 => 1, 3996 => 1, 3997 => 1, 3998 => 1, 4000 => 1, 4187 => 2, 4320 => 3, 4321 => 3, 4322 => 3},

  # 獣技
248 => {4002 => 1, 4003 => 1, 4004 => 1, 4005 => 1, 4006 => 1, 4007 => 1, 4008 => 1, 4009 => 1, 4011 => 1, 4012 => 1, 
        4013 => 1, 4015 => 1, 4016 => 1, 4017 => 1, 4018 => 1, 4023 => 1, 4025 => 1, 4026 => 1, 4027 => 1, 4323 => 3, 4324 => 3, 4325 => 3, 4326 => 3},

  # 蛇技
249 => {4028 => 1, 4030 => 1, 4031 => 1, 4032 => 1, 4033 => 1, 4034 => 1, 4035 => 1, 4036 => 1, 4037 => 1, 4038 => 1, 
        4039 => 1, 4188 => 2, 4327 => 3, 4328 => 3, 4329 => 3},

  # 触手技
250 => {4041 => 1, 4042 => 1, 4043 => 1, 4045 => 1, 4046 => 1, 4047 => 1, 4048 => 1, 4049 => 1, 4051 => 1, 4330 => 3, 4331 => 3, 4332 => 3, 4333 => 3},

  # 翼技
251 => {4053 => 1, 4054 => 1, 4056 => 1, 4057 => 1, 4058 => 1, 4334 => 3, 4335 => 3, 4336 => 3},

  # 虫技
252 => {4059 => 1, 4060 => 1, 4061 => 1, 4063 => 1, 4064 => 1, 4065 => 1, 4067 => 1, 4068 => 1, 4069 => 1, 4070 => 1, 
        4071 => 1, 4072 => 1, 4074 => 1, 4075 => 1, 4076 => 1, 4077 => 1, 4078 => 1, 4337 => 3, 4338 => 3, 4339 => 3, 4340 => 3},

  # 植物技
253 => {4080 => 1, 4081 => 1, 4083 => 1, 4084 => 1, 4085 => 1, 4086 => 1, 4087 => 1, 4189 => 3, 4341 => 3, 4342 => 3, 4343 => 3, 4344 => 3},

  # 屍技
254 => {4088 => 1, 4089 => 1, 4090 => 1, 4091 => 1, 4093 => 1, 4094 => 1, 4095 => 1, 4096 => 1, 4345 => 3, 4346 => 3, 4347 => 3, 4348 => 3},


  # 造技
255 => {4097 => 1, 4098 => 1, 4099 => 1, 4100 => 1, 4101 => 1, 4104 => 1, 4105 => 1, 4106 => 1, 4107 => 1, 4108 => 1, 
        4109 => 1, 4110 => 1, 4112 => 1, 4113 => 1, 4114 => 1, 4190 => 1, 4349 => 3, 4350 => 3, 4351 => 3, 4352 => 3,
        4422 => 1, 4423 => 1, 4424 => 1, 4425 => 1, 4426 => 1, 4427 => 1},

  # 自然感応
256 => {4116 => 1, 4117 => 1, 4118 => 1, 4119 => 1, 4120 => 1, 4121 => 1, 4122 => 1, 4123 => 1, 4124 => 1, 4125 => 1, 
        4126 => 1, 4127 => 1, 4128 => 1, 4191 => 2, 4353 => 3, 4354 => 3},

  # ブレス
257 => {4129 => 1, 4130 => 1, 4133 => 1, 4134 => 1, 4136 => 1, 4137 => 1, 4138 => 1, 4355 => 3, 4356 => 3, 4357 => 3},

  # 巨体技
258 => {4102 => 1, 4103 => 1, 4143 => 1},

  # 料理
259 => {4147 => 1, 4148 => 1, 4149 => 1, 4150 => 1, 4151 => 1, 4152 => 1, 4153 => 1, 4154 => 1, 4181 => 3, 4292 => 3, 4293 => 3, 4294 => 3},

  # 特技
260 => {4192 => 1, 4358 => 3, 4359 => 3, 4360 => 3, 4361 => 3},

  # EXアイテム
261 => {4277 => 3},

  # サイコ
262 => {4413 => 1, 4414 => 1, 4415 => 1, 4416 => 1, 4417 => 1, 4418 => 1, 4419 => 3, 4420 => 3},

  # 巨技
263 => {4102 => 1, 4103 => 1, 4104 => 1, 4431 => 1, 4432 => 1, 4433 => 1, 4429 => 3, 4430 => 3},

  # 投擲技（盾）
264 => {4193 => 1, 4434 => 1},


  # 武器共通レジェンド付加能力
401 => {4501 => 1, 4502 => 1, 4503 => 1, 4504 => 1, 4505 => 1, 4506 => 1, 4507 => 1, 4508 => 1, 4509 => 1, 4510 => 1,
        4511 => 1, 4512 => 1, 4513 => 1, 4514 => 1, 4515 => 1, 4518 => 1, 4519 => 1,
        4547 => 1, 4548 => 1, 4549 => 1, 4550 => 1,
        4551 => 1, 4552 => 1, 4553 => 1, 4554 => 1, 4555 => 1, 4556 => 1, 4557 => 1, 4558 => 1, 4559 => 1, 4560 => 1,
        4561 => 1, 4562 => 1, 4563 => 1, 4564 => 1, 4565 => 1, 4566 => 1, 4567 => 1, 4568 => 1, 4569 => 1, 4570 => 1,
        4571 => 1, 4572 => 1, 4573 => 1, 4574 => 1, 4575 => 1, 4576 => 1, 4577 => 1, 4578 => 1, 4579 => 1, 4580 => 1,
        4581 => 1, 4582 => 1, 4583 => 1, 4584 => 1, 4585 => 1, 4586 => 1, 4587 => 1, 4588 => 1, 4589 => 1, 4590 => 1,
        4591 => 1, 4592 => 1, 4593 => 1, 4594 => 1, 4595 => 1, 4596 => 1, 4597 => 1, 4598 => 1, 4599 => 1, 4600 => 1,
        4601 => 1, 4602 => 1, 4603 => 1, 4604 => 1, 4606 => 1, 4607 => 1, 4608 => 1, 4656 => 1, 4657 => 1, 4658 => 1},

  # 鎧共通レジェンド付加能力
402 => {4516 => 1, 4517 => 1, 4520 => 1, 4521 => 1, 4522 => 1, 4523 => 1, 4524 => 1, 4525 => 1, 4526 => 1, 4527 => 1, 4528 => 1, 4529 => 1, 4530 => 1, 
        4503 => 1, 4504 => 1, 4505 => 1, 4506 => 1, 4507 => 1, 4508 => 1, 4509 => 1, 4510 => 1, 4511 => 1, 4512 => 1, 4513 => 1,
        4638 => 1, 4639 => 1, 4640 => 1, 4641 => 1,
        4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4535 => 1, 4536 => 1, 4537 => 1, 4538 => 1, 4539 => 1, 4540 => 1,
        4541 => 1, 4542 => 1, 4543 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4637 => 1, 4642 => 1, 4643 => 1, 4644 => 1,
        4645 => 1, 4646 => 1, 4647 => 1, 4648 => 1, 4649 => 1, 4650 => 1, 4651 => 1, 4652 => 1, 4653 => 1, 4654 => 1,
        4655 => 1, 4659 => 1},

  # 兜共通レジェンド付加能力
403 => {4516 => 1, 4517 => 1, 4520 => 1, 4521 => 1, 4522 => 1, 4523 => 1, 4524 => 1, 4525 => 1, 4526 => 1, 4527 => 1, 4528 => 1, 4529 => 1, 4530 => 1, 
        4547 => 1, 4548 => 1, 4549 => 1, 4550 => 1,
        4551 => 1, 4552 => 1, 4553 => 1, 4554 => 1, 4555 => 1, 4556 => 1, 4557 => 1, 4558 => 1, 4559 => 1, 4560 => 1,
        4561 => 1, 4562 => 1, 4563 => 1, 4564 => 1, 4565 => 1, 4566 => 1, 4567 => 1, 4568 => 1, 4569 => 1, 4570 => 1,
        4571 => 1, 4572 => 1, 4573 => 1, 4574 => 1, 4575 => 1, 4576 => 1, 4577 => 1, 4578 => 1, 4579 => 1, 4580 => 1,
        4581 => 1, 4582 => 1, 4583 => 1, 4584 => 1, 4585 => 1, 4586 => 1, 4587 => 1, 4588 => 1, 4589 => 1, 4590 => 1,
        4591 => 1, 4592 => 1, 4593 => 1, 4594 => 1, 4595 => 1, 4596 => 1, 4597 => 1, 4598 => 1, 4599 => 1, 4600 => 1,
        4601 => 1, 4602 => 1, 4603 => 1, 4604 => 1,
        4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4535 => 1, 4536 => 1, 4537 => 1, 4538 => 1, 4539 => 1, 4540 => 1,
        4541 => 1, 4542 => 1, 4543 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4637 => 1, 4642 => 1, 4643 => 1, 4644 => 1,
        4645 => 1, 4646 => 1, 4647 => 1, 4648 => 1, 4649 => 1, 4650 => 1, 4651 => 1, 4652 => 1, 4653 => 1, 4654 => 1,
        4655 => 1, 4657 => 1, 4658 => 1, 4659 => 1},

  # 盾共通レジェンド付加能力
404 => {4516 => 1, 4517 => 1, 4520 => 1, 4521 => 1, 4522 => 1, 4523 => 1, 4524 => 1, 4525 => 1, 4526 => 1, 4527 => 1, 4528 => 1, 4529 => 1, 4530 => 1, 
        4605 => 1, 4609 => 1, 4610 => 1, 4611 => 1, 4612 => 1, 4613 => 1, 4614 => 1, 4615 => 1, 4616 => 1, 4617 => 1, 4618 => 1,
        4619 => 1, 4620 => 1, 4621 => 1, 4622 => 1, 4623 => 1, 4624 => 1, 4625 => 1, 4626 => 1, 4627 => 1, 4628 => 1,
        4629 => 1, 4630 => 1, 4631 => 1, 4632 => 1, 4633 => 1, 4634 => 1, 4635 => 1, 4636 => 1,
        4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4535 => 1, 4536 => 1, 4537 => 1, 4538 => 1, 4539 => 1, 4540 => 1,
        4541 => 1, 4542 => 1, 4543 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4637 => 1, 4642 => 1, 4643 => 1, 4644 => 1,
        4645 => 1, 4646 => 1, 4647 => 1, 4648 => 1, 4649 => 1, 4650 => 1, 4651 => 1, 4652 => 1, 4653 => 1, 4654 => 1,
        4655 => 1, 4659 => 1},

  # アクセサリ共通レジェンド付加能力
405 => {4516 => 1, 4517 => 1, 4520 => 1, 4521 => 1, 4522 => 1, 4523 => 1, 4524 => 1, 4525 => 1, 4526 => 1, 4527 => 1, 4528 => 1, 4529 => 1, 4530 => 1,
        4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4535 => 1, 4536 => 1, 4537 => 1, 4538 => 1, 4539 => 1, 4540 => 1,
        4541 => 1, 4542 => 1, 4543 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4637 => 1, 4642 => 1, 4643 => 1, 4644 => 1,
        4645 => 1, 4646 => 1, 4647 => 1, 4648 => 1, 4649 => 1, 4650 => 1, 4651 => 1, 4652 => 1, 4653 => 1, 4654 => 1,
        4655 => 1, 4659 => 1},

  # 短剣・レジェンド
411 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4659 => 1},

  # 剣・レジェンド
412 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4535 => 2, 4538 => 1, 4645 => 2},

  # 騎士剣・レジェンド
413 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4535 => 2, 4538 => 1, 4645 => 2, 4647 => 1},

  # 巨剣・レジェンド
414 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4535 => 2, 4645 => 1, 4647 => 2},

  # 尖剣・レジェンド
415 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4651 => 2, 4659 => 1},

  # 魔導剣・レジェンド
416 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4535 => 2, 5188 => 1, 4541 => 1, 4543 => 1, 4646 => 1, 4659 => 1},

  # 槍・レジェンド
417 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4540 => 2, 4542 => 2},

  # 重槍・レジェンド
418 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4540 => 2, 4542 => 2},

  # 刀・レジェンド
419 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4538 => 1, 4649 => 2},

  # 忍者刀・レジェンド
420 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4653 => 2},

  # 拳・レジェンド
421 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4538 => 1, 4652 => 2, 4659 => 1},

  # 牙・レジェンド
422 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4659 => 1},

  # 斧・レジェンド
423 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1},

  # 棍・レジェンド
424 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4536 => 2, 4659 => 1},

  # 鎌・レジェンド
425 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4541 => 2, 4543 => 1, 4659 => 1},

  # 杖・レジェンド
426 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4539 => 2, 4540 => 1, 4543 => 2, 4648 => 1, 4659 => 1},

  # ロッド・レジェンド
427 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 5188 => 1, 4541 => 2, 4543 => 2, 4643 => 1, 4646 => 2, 4659 => 1},

  # 弓矢・レジェンド
428 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4537 => 2, 4539 => 1},

  # 鞭・レジェンド
429 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4637 => 2, 4659 => 1},

  # 竪琴・レジェンド
430 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4642 => 2, 4659 => 1},

  # ブーメラン・レジェンド
431 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4659 => 1},

  # 鉄球・レジェンド
432 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4659 => 1},

  # 扇・レジェンド
433 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4642 => 2, 4646 => 1, 4659 => 1},

  # 包丁・レジェンド
434 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1},

  # そろばん・レジェンド
435 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1},

  # メス・レジェンド
436 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4648 => 2},

  # カード・レジェンド
437 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1},

  # 皿・レジェンド
438 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4655 => 2},

  # 魔導書・レジェンド
439 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4541 => 1, 4543 => 2, 4643 => 2, 4650 => 2},

  # 銃・レジェンド
440 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4538 => 1, 4644 => 2, 4647 => 1, 4654 => 2},

  # 淫具・レジェンド
441 => {4531 => 1, 4532 => 1, 4533 => 1, 4534 => 1, 4544 => 1, 4545 => 1, 4546 => 1, 4637 => 2},



  # ラルス・剣
501 => {4363 => 2, 4364 => 2, 4387 => 2, 5001 => 2, 5098 => 2},

  # ラルス・服
502 => {5002 => 2, 5003 => 2, 5004 => 2, 5005 => 2, 5006 => 2, 5007 => 2},

  # ラルス・竜石
503 => {5008 => 2, 5009 => 2, 5010 => 2},

  # ルヴィッサ・杖
504 => {4365 => 2, 5011 => 2},

  # ルヴィッサ・ドレス
505 => {5012 => 2, 5013 => 2},

  # ルヴィッサ・リボン
506 => {5001 => 2, 5014 => 2, 5015 => 2},

  # ルヴィッサ・アクセサリ
507 => {5016 => 2, 5017 => 2, 5018 => 2},

  # エスト・ドレス
508 => {4366 => 2, 4367 => 2, 5019 => 2, 5020 => 2, 5021 => 2},

  # エスト・・アクセサリ
509 => {5022 => 2, 5023 => 2, 5024 => 2, 5025 => 2, 5026 => 2},

  # ミュスカ・弓
510 => {4396 => 2, 4397 => 2, 4401 => 2, 4410 => 2, 5019 => 2, 5027 => 2},

  # ミュスカ・薄着
511 => {5021 => 2, 5028 => 2},

  # ミュスカ・アクセサリ
512 => {5029 => 2, 5030 => 2, 5031 => 2},

  # ネメア・杖
513 => {4398 => 2, 4401 => 2, 5019 => 2, 5032 => 2, 5033 => 2},

  # ネメア・アクセサリ
514 => {5034 => 2, 5035 => 2, 5036 => 2},

  # ヴィヌム・拳
515 => {4399 => 2, 4400 => 2, 4401 => 2, 5019 => 2, 5037 => 2},

  # ヴィヌム・アクセサリ
516 => {5038 => 2, 5039 => 2, 5040 => 2, 5041 => 2, 5042 => 2},

  # ロウラット・ロッド
517 => {4368 => 2, 4388 => 2, 4389 => 2, 5011 => 2, 5043 => 2, 5044 => 2},

  # ロウラット・アクセサリ
518 => {5045 => 2, 5046 => 2, 5047 => 2, 5048 => 2},

  # リジェオ・ロッド
519 => {4408 => 2, 4409 => 2, 5049 => 2, 5050 => 2, 5051 => 2, 5187 => 2},

  # リジェオ・ドレス
520 => {5052 => 2, 5053 => 2, 5054 => 2, 5055 => 2},

  # リジェオ・アクセサリ
521 => {4369 => 2, 5020 => 2, 5021 => 2, 5056 => 2},

  # フルビュア・鞭
522 => {4369 => 2, 4406 => 2, 5057 => 2, 5058 => 2, 5059 => 2, 5060 => 2, 5061 => 2},

  # ギルゴーン・高級帽
523 => {4370 => 2, 4371 => 2, 4372 => 2, 5062 => 2, 5063 => 2},

  # ギルゴーン・アクセサリ
524 => {5064 => 2, 5065 => 2, 5066 => 2, 5067 => 2},

  # 白念・拳
525 => {4373 => 2, 4374 => 2, 5038 => 2},

  # 白念・防具
526 => {5068 => 2, 5069 => 2, 5070 => 2, 5071 => 2},

  # 白念・アクセサリ
527 => {5072 => 2, 5073 => 2, 5074 => 2, 5075 => 2},

  # マガツ・棍
528 => {4375 => 2, 4376 => 2, 4377 => 2, 5189 => 2},

  # マガツ・服
529 => {5076 => 2, 5077 => 2, 5078 => 2, 5079 => 2, 5080 => 2},

  # マガツ・アクセサリ
530 => {5081 => 2, 5082 => 2},

  # 夢狐・服
531 => {5083 => 2},

  # 夢狐・高級帽
532 => {5084 => 2},

  # 大明海・ロッド
533 => {4373 => 2, 4378 => 2, 5085 => 2, 5086 => 2, 5087 => 2},

  # 大明海・魔導剣
534 => {4373 => 2, 4378 => 2, 4402 => 2, 5088 => 2},

  # 大明海・盾
535 => {4403 => 2, 5089 => 2},

  # 大明海・ローブ
536 => {4404 => 2, 5090 => 2},

  # 大明海・魔帽
537 => {5091 => 2, 5092 => 2},

  # 大明海・アクセサリ
538 => {5093 => 2, 5094 => 2},

  # カズヤ・銃
539 => {4411 => 2, 5095 => 2, 5096 => 2, 5097 => 2, 5098 => 2},

  # カズヤ・杖
540 => {4379 => 2, 5099 => 2, 5100 => 2, 5101 => 2},

  # カズヤ・剣
541 => {5098 => 2, 5102 => 2},

  # カズヤ・鎧
542 => {5071 => 2, 5103 => 2, 5104 => 2},

  # カズヤ・アクセサリ
543 => {5105 => 2, 5106 => 2, 5107 => 2},

  # ランパス・鞭
544 => {5108 => 2, 5109 => 2},

  # ランパス・アクセサリ
545 => {5021 => 2, 5110 => 2, 5111 => 2},

  # 躯・刀
546 => {4380 => 2, 4381 => 2, 5112 => 2},

  # 躯・アクセサリ
547 => {5113 => 2, 5114 => 2, 5115 => 2, 5116 => 2},

  # 妲己・魔導剣
548 => {4385 => 2, 5011 => 2, 5117 => 2, 5118 => 2},

  # 妲己・ドレス
549 => {5119 => 2, 5120 => 2, 5121 => 2},

  # 妲己・アクセサリ
550 => {5021 => 2, 5122 => 2, 5123 => 2, 5124 => 2},

  # レスト・騎士剣
551 => {4382 => 2, 5098 => 2},

  # レスト・鎧
552 => {5125 => 2, 5126 => 2, 5127 => 2},

  # レスト・兜
553 => {5128 => 2, 5129 => 2},

  # レスト・盾
554 => {5130 => 2, 5131 => 2, 5132 => 2},

  # レスト・アクセサリ
555 => {5133 => 2, 5134 => 2},

  # ベル・拳
556 => {4383 => 2, 5118 => 2, 5136 => 2},

  # ベル・服
557 => {5019 => 2, 5021 => 2, 5037 => 2, 5137 => 2, 5138 => 2},

  # ベル・アクセサリ
558 => {5038 => 2, 5140 => 2, 5141 => 2, 5142 => 2},

  # リラ・拳
559 => {4383 => 2, 5118 => 2, 5135 => 2},

  # ミュゼット・ロッド
560 => {4384 => 2, 5043 => 2, 5118 => 2, 5143 => 2, 5144 => 2},

  # ミュゼット・アクセサリ
561 => {5145 => 2, 5146 => 2, 5147 => 2, 5148 => 2, 5149 => 2},

  # ノビッサ・巨剣
562 => {4390 => 2, 5098 => 2, 5150 => 2},

  # ノビッサ・兜
563 => {5128 => 2, 5152 => 2, 5153 => 2},

  # ノビッサ・盾
564 => {5154 => 2, 5155 => 2},

  # ノビッサ・アクセサリ
565 => {5156 => 2, 5157 => 2, 5158 => 2},

  # ターサ・扇
566 => {5118 => 2, 5159 => 2, 5160 => 2},

  # ターサ・帽子
567 => {5155 => 2, 5161 => 2, 5162 => 2, 5163 => 2},

  # ターサ・アクセサリ
568 => {5019 => 2, 5020 => 2, 5164 => 2},

  # エクス・鎌
569 => {4386 => 2, 4391 => 2, 4392 => 2, 5118 => 2},

  # エクス・服
570 => {5171 => 2},

  # エクス・アクセサリ
571 => {5165 => 2, 5168 => 2, 5172 => 2, 5173 => 2, 5174 => 2, 5175 => 2, 5176 => 2, 5177 => 2},

  # オーガ・拳
572 => {4393 => 2, 4394 => 2, 5038 => 2, 5098 => 2, 5118 => 2},

  # オーガ・アクセサリ
573 => {5166 => 2, 5169 => 2, 5178 => 2, 5179 => 2, 5180 => 2, 5181 => 2, 5182 => 2},

  # ミスト・魔導剣
574 => {4386 => 2, 4390 => 2, 4395 => 2, 5011 => 2, 5098 => 2, 5118 => 2},

  # ミスト・アクセサリ
575 => {5167 => 2, 5170 => 2, 5183 => 2, 5184 => 2, 5185 => 2, 5186 => 2},

}

end

#==============================================================================
# ■ NWConst::Wepon
#==============================================================================
module NWConst::Weapon
  
  ENCAHNT_DATA ={

  # 短剣
    1001..1006=>{
      # エンチャント付与数
      # 例では3~5個付与される。
      :enchant_count =>2..3,
      
      # アイテムの色 0は通常（白色）、1は青、2は黄、3はオレンジ、4は緑
      # 省略可、省略すると0扱い。
      :display_color => 1,
      
      # 接頭無視　0で接頭が表示され、1で表示されない。
      # 省略可、省略すると0扱い。
      :not_prefix => 0,

      1..2000 =>{
        :enchants => [1],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [1],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [1],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [1],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [1],
        :socket=>{3=>100},
      }
    },
    1007..1010=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [1,2,202,228],
        :socket=>{3=>100},
      },
    },
    1011..1016=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [3],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [3],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [3],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [3],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [3],
        :socket=>{3=>100},
      }
    },
    1017..1020=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [3,4,202,228],
        :socket=>{3=>100},
      },
    },
    1021..1100=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [1,2,4,202,228],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [1,2,4,202,228,401,411],
        :socket=>{3=>100},
      }
    },

  # 剣
    1101..1106=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [5],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [5],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [5],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [5],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [5],
        :socket=>{3=>100},
      }
    },
    1107..1110=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [5,6,203,216,230],
        :socket=>{3=>100},
      },
    },
    1111..1116=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [7],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [7],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [7],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [7],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [7],
        :socket=>{3=>100},
      }
    },
    1117..1120=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [7,8,203,216,230],
        :socket=>{3=>100},
      },
    },
    1121..1200=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [5,6,8,203,216,230],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [5,6,8,203,216,230,401,412],
        :socket=>{3=>100},
      }
    },

  # 騎士剣
    1201..1206=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [9],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [9],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [9],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [9],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [9],
        :socket=>{3=>100},
      }
    },
    1207..1210=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [9,10,203,225,231,241,243],
        :socket=>{3=>100},
      },
    },
    1211..1216=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [11],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [11],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [11],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [11],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [11],
        :socket=>{3=>100},
      }
    },
    1217..1220=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [11,12,203,225,231,241,243],
        :socket=>{3=>100},
      },
    },
    1221..1300=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [9,10,12,203,225,231,241,243],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [9,10,12,203,225,231,241,243,401,413],
        :socket=>{3=>100},
      }
    },

  # 巨剣
    1301..1303=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [13],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [13],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [13],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [13],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [13],
        :socket=>{3=>100},
      }
    },
    1304..1305=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [13,14,203,263],
        :socket=>{3=>100},
      },
    },
    1306..1308=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [15],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [15],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [15],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [15],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [15],
        :socket=>{3=>100},
      }
    },
    1309..1310=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [15,16,203,263],
        :socket=>{3=>100},
      },
    },
    1311..1350=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [13,14,16,203,263],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [13,14,16,203,401,414,263],
        :socket=>{3=>100},
      }
    },

  # 尖剣
    1351..1356=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [17],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [17],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [17],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [17],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [17],
        :socket=>{3=>100},
      }
    },
    1357..1360=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [17,18,204,226],
        :socket=>{3=>100},
      },
    },
    1361..1366=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [19],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [19],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [19],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [19],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [19],
        :socket=>{3=>100},
      }
    },
    1367..1370=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [19,20,204,226],
        :socket=>{3=>100},
      },
    },
    1371..1450=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [17,18,20,204,226],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [17,18,20,204,226,401,415],
        :socket=>{3=>100},
      }
    },

  # 魔導剣
    1451..1453=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [21],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [21],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [21],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [21],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [21],
        :socket=>{3=>100},
      }
    },
    1454..1455=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [21,22,203,219,262],
        :socket=>{3=>100},
      },
    },
    1456..1458=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [23],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [23],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [23],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [23],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [23],
        :socket=>{3=>100},
      }
    },
    1459..1460=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [23,24,203,219,262],
        :socket=>{3=>100},
      },
    },
    1461..1500=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [21,22,24,203,219,262],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [21,22,24,203,219,262,401,416],
        :socket=>{3=>100},
      }
    },

  # 槍
    1501..1503=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [25],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [25],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [25],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [25],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [25],
        :socket=>{3=>100},
      }
    },
    1504..1505=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [25,26,206],
        :socket=>{3=>100},
      },
    },
    1506..1508=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [27],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [27],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [27],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [27],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [27],
        :socket=>{3=>100},
      }
    },
    1509..1510=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [27,28,206],
        :socket=>{3=>100},
      },
    },
    1511..1550=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [25,26,28,206],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [25,26,28,206,401,417],
        :socket=>{3=>100},
      }
    },

  # 重槍
    1551..1556=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [29],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [29],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [29],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [29],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [29],
        :socket=>{3=>100},
      }
    },
    1557..1560=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [29,30,206],
        :socket=>{3=>100},
      },
    },
    1561..1566=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [31],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [31],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [31],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [31],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [31],
        :socket=>{3=>100},
      }
    },
    1567..1570=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [31,32,206],
        :socket=>{3=>100},
      },
    },
    1571..1650=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [29,30,32,206],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [29,30,32,206,401,418],
        :socket=>{3=>100},
      }
    },

  # 刀
    1651..1662=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [33],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [33],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [33],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [33],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [33],
        :socket=>{3=>100},
      }
    },
    1663..1670=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [33,34,205,216],
        :socket=>{3=>100},
      },
    },
    1671..1750=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [33,34,36,205,216],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [33,34,36,205,216,401,419],
        :socket=>{3=>100},
      }
    },

  # 忍者刀
    1751..1762=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [37],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [37],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [37],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [37],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [37],
        :socket=>{3=>100},
      }
    },
    1763..1770=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [37,38,229],
        :socket=>{3=>100},
      },
    },
    1771..1850=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [37,38,40,229],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [37,38,40,229,401,420],
        :socket=>{3=>100},
      }
    },

  # 拳
    1851..1856=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [41],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [41],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [41],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [41],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [41],
        :socket=>{3=>100},
      }
    },
    1857..1860=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [41,42,217,231,262],
        :socket=>{3=>100},
      },
    },
    1861..1866=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [43],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [43],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [43],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [43],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [43],
        :socket=>{3=>100},
      }
    },
    1867..1870=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [43,44,217,231,262],
        :socket=>{3=>100},
      },
    },
    1871..1950=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [41,42,44,217,231,262],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [41,42,44,217,231,244,262,401,421],
        :socket=>{3=>100},
      }
    },

  # 牙
    1951..1956=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [45],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [45],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [45],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [45],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [45],
        :socket=>{3=>100},
      }
    },
    1957..1960=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [45,46],
        :socket=>{3=>100},
      },
    },
    1961..1966=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [47],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [47],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [47],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [47],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [47],
        :socket=>{3=>100},
      }
    },
    1967..1970=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [47,48],
        :socket=>{3=>100},
      },
    },
    1971..2050=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [45,46,48],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [45,46,48,401,422],
        :socket=>{3=>100},
      }
    },

  # 斧
    2051..2056=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [49],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [49],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [49],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [49],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [49],
        :socket=>{3=>100},
      }
    },
    2057..2060=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [49,50,207,263],
        :socket=>{3=>100},
      },
    },
    2061..2066=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [51],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [51],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [51],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [51],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [51],
        :socket=>{3=>100},
      }
    },
    2067..2070=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [51,52,207,263],
        :socket=>{3=>100},
      },
    },
    2071..2150=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [49,50,52,207,263],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [49,50,52,207,401,423,263],
        :socket=>{3=>100},
      }
    },

  # 棍
    2151..2156=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [53],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [53],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [53],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [53],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [53],
        :socket=>{3=>100},
      }
    },
    2157..2160=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [53,54,208,263],
        :socket=>{3=>100},
      },
    },
    2161..2166=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [55],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [55],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [55],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [55],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [55],
        :socket=>{3=>100},
      }
    },
    2167..2170=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [55,56,208,263],
        :socket=>{3=>100},
      },
    },
    2171..2250=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [53,54,56,208,263],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [53,54,56,208,401,424,263],
        :socket=>{3=>100},
      }
    },

  # 鎌
    2251..2256=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [57],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [57],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [57],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [57],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [57],
        :socket=>{3=>100},
      }
    },
    2257..2260=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [57,58,209,226,227],
        :socket=>{3=>100},
      },
    },
    2261..2266=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [59],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [59],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [59],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [59],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [59],
        :socket=>{3=>100},
      }
    },
    2267..2270=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [59,60,209,226,227],
        :socket=>{3=>100},
      },
    },
    2271..2350=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [57,58,60,209,226,227],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [57,58,60,209,226,227,401,425],
        :socket=>{3=>100},
      }
    },

  # 杖
    2351..2356=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [61],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [61],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [61],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [61],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [61],
        :socket=>{3=>100},
      }
    },
    2357..2360=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [61,62,218,225,242],
        :socket=>{3=>100},
      },
    },
    2361..2366=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [63],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [63],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [63],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [63],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [63],
        :socket=>{3=>100},
      }
    },
    2367..2370=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [66,64,218,225,242],
        :socket=>{3=>100},
      },
    },
    2371..2450=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [61,62,64,218,225,242],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [61,62,64,218,225,242,401,426],
        :socket=>{3=>100},
      }
    },

  # ロッド
    2451..2456=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [65],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [65],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [65],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [65],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [65],
        :socket=>{3=>100},
      }
    },
    2457..2460=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [65,66,219,220,221,223,226,227,244,262],
        :socket=>{3=>100},
      },
    },
    2461..2466=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [67],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [67],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [67],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [67],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [67],
        :socket=>{3=>100},
      }
    },
    2467..2470=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [67,68,219,220,221,223,226,227,244,262],
        :socket=>{3=>100},
      },
    },
    2471..2550=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [65,66,68,219,220,221,223,226,227,244,262],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [65,66,68,219,220,221,223,226,227,244,262,401,427],
        :socket=>{3=>100},
      }
    },

  # 弓矢
    2551..2556=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [69],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [69],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [69],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [69],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [69],
        :socket=>{3=>100},
      }
    },
    2557..2560=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [69,70,210,225],
        :socket=>{3=>100},
      },
    },
    2561..2566=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [71],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [71],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [71],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [71],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [71],
        :socket=>{3=>100},
      }
    },
    2567..2570=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [71,72,210,225],
        :socket=>{3=>100},
      },
    },
    2571..2650=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [69,70,72,210,225],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [69,70,72,210,225,401,428],
        :socket=>{3=>100},
      }
    },

  # 鞭
    2651..2656=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [73],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [73],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [73],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [73],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [73],
        :socket=>{3=>100},
      }
    },
    2657..2660=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [73,74,211,244,262],
        :socket=>{3=>100},
      },
    },
    2661..2666=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [75],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [75],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [75],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [75],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [75],
        :socket=>{3=>100},
      }
    },
    2667..2670=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [75,76,211,244,262],
        :socket=>{3=>100},
      },
    },
    2671..2750=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [73,74,76,211,244,262],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [73,74,76,211,244,262,401,429],
        :socket=>{3=>100},
      }
    },

  # 竪琴
    2751..2756=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [77],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [77],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [77],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [77],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [77],
        :socket=>{3=>100},
      }
    },
    2757..2760=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [77,78,234],
        :socket=>{3=>100},
      },
    },
    2761..2766=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [79],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [79],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [79],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [79],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [79],
        :socket=>{3=>100},
      }
    },
    2767..2770=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [79,80,234],
        :socket=>{3=>100},
      },
    },
    2771..2850=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [77,78,80,234],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [77,78,80,234,401,430],
        :socket=>{3=>100},
      }
    },

  # ブーメラン
    2851..2856=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [81],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [81],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [81],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [81],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [81],
        :socket=>{3=>100},
      }
    },
    2857..2860=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [81,82,212,261],
        :socket=>{3=>100},
      },
    },
    2861..2866=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [83],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [83],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [83],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [83],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [83],
        :socket=>{3=>100},
      }
    },
    2867..2870=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [83,84,212,261],
        :socket=>{3=>100},
      },
    },
    2871..2950=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [81,82,84,212,261],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [81,82,84,212,261,401,431],
        :socket=>{3=>100},
      }
    },

  # 鉄球
    2951..2956=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [85],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [85],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [85],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [85],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [85],
        :socket=>{3=>100},
      }
    },
    2957..2960=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [85,86,213],
        :socket=>{3=>100},
      },
    },
    2961..2966=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [87],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [87],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [87],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [87],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [87],
        :socket=>{3=>100},
      }
    },
    2967..2970=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [87,88,213],
        :socket=>{3=>100},
      },
    },
    2971..3050=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [85,86,88,213],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [85,86,88,213,401,432],
        :socket=>{3=>100},
      }
    },

  # 扇
    3051..3056=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [89],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [89],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [89],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [89],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [89],
        :socket=>{3=>100},
      }
    },
    3057..3060=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [89,90,214,233],
        :socket=>{3=>100},
      },
    },
    3061..3066=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [91],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [91],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [91],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [91],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [91],
        :socket=>{3=>100},
      }
    },
    3067..3070=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [91,92,214,233],
        :socket=>{3=>100},
      },
    },
    3071..3150=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [89,90,92,214,233],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [89,90,92,214,233,401,433],
        :socket=>{3=>100},
      }
    },

  # 包丁
    3151..3156=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [93],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [93],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [93],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [93],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [93],
        :socket=>{3=>100},
      }
    },
    3157..3160=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [93,94,259],
        :socket=>{3=>100},
      },
    },
    3161..3166=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [95],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [95],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [95],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [95],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [95],
        :socket=>{3=>100},
      }
    },
    3167..3170=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [95,96,259],
        :socket=>{3=>100},
      },
    },
    3171..3250=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [93,94,96,259],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [93,94,96,259,401,434],
        :socket=>{3=>100},
      }
    },

  # そろばん
    3251..3256=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [97],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [97],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [97],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [97],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [97],
        :socket=>{3=>100},
      }
    },
    3257..3260=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [97,98,261],
        :socket=>{3=>100},
      },
    },
    3261..3266=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [99],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [99],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [99],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [99],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [99],
        :socket=>{3=>100},
      }
    },
    3267..3270=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [99,100,261],
        :socket=>{3=>100},
      },
    },
    3271..3350=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [97,98,100,261],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [97,98,100,261,401,435],
        :socket=>{3=>100},
      }
    },

  # メス
    3351..3356=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [101],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [101],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [101],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [101],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [101],
        :socket=>{3=>100},
      }
    },
    3357..3360=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [101,102,222,239],
        :socket=>{3=>100},
      },
    },
    3361..3366=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [103],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [103],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [103],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [103],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [103],
        :socket=>{3=>100},
      }
    },
    3367..3370=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [103,104,222,239],
        :socket=>{3=>100},
      },
    },
    3371..3450=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [101,102,104,222,239],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [101,102,104,222,239,401,436],
        :socket=>{3=>100},
      }
    },

  # カード
    3451..3456=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [105],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [105],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [105],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [105],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [105],
        :socket=>{3=>100},
      }
    },
    3457..3460=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [105,106,232],
        :socket=>{3=>100},
      },
    },
    3461..3466=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [107],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [107],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [107],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [107],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [107],
        :socket=>{3=>100},
      }
    },
    3467..3470=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [107,108,232],
        :socket=>{3=>100},
      },
    },
    3471..3550=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [105,106,108,232],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [105,106,108,232,401,437],
        :socket=>{3=>100},
      }
    },

  # 皿
    3551..3556=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [109],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [109],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [109],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [109],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [109],
        :socket=>{3=>100},
      }
    },
    3557..3560=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [109,110,240],
        :socket=>{3=>100},
      },
    },
    3561..3566=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [111],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [111],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [111],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [111],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [111],
        :socket=>{3=>100},
      }
    },
    3567..3570=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [111,112,240],
        :socket=>{3=>100},
      },
    },
    3571..3650=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [109,110,112,240],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [109,110,112,240,401,438],
        :socket=>{3=>100},
      }
    },

  # 魔導書
    3651..3656=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [113],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [113],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [113],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [113],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [113],
        :socket=>{3=>100},
      }
    },
    3657..3660=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [113,114,236,237],
        :socket=>{3=>100},
      },
    },
    3661..3666=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [115],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [115],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [115],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [115],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [115],
        :socket=>{3=>100},
      }
    },
    3667..3670=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [115,116,236,237],
        :socket=>{3=>100},
      },
    },
    3671..3750=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [113,114,116,236,237],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [113,114,116,236,237,401,439],
        :socket=>{3=>100},
      }
    },

  # 銃
    3751..3756=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [117],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [117],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [117],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [117],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [117],
        :socket=>{3=>100},
      }
    },
    3757..3760=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [117,118,215,224,235,238,242],
        :socket=>{3=>100},
      },
    },
    3761..3766=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [119],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [119],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [119],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [119],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [119],
        :socket=>{3=>100},
      }
    },
    3767..3770=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [119,120,215,224,235,238,242],
        :socket=>{3=>100},
      },
    },
    3771..3850=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [117,118,120,215,224,235,238,242],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [117,118,120,215,224,235,238,242,401,440],
        :socket=>{3=>100},
      }
    },

  # 淫具
    3851..3856=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [121],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [121],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [121],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [121],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [121],
        :socket=>{3=>100},
      }
    },
    3857..3860=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [121,122,244,262],
        :socket=>{3=>100},
      },
    },
    3861..3866=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [123],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [123],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [123],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [123],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [123],
        :socket=>{3=>100},
      }
    },
    3867..3870=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [123,124,244,262],
        :socket=>{3=>100},
      },
    },
    3871..3950=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [121,122,124,262],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [121,122,124,262,401,441],
        :socket=>{3=>100},
      }
    },

  # カオス
    3951=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [73,74,76,211,244],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [73,74,76,211,244,401,429],
        :socket=>{3=>100},
      }
    },
    3952=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [117,118,120,215,224,235,238,242],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [117,118,120,215,224,235,238,242,401,440],
        :socket=>{3=>100},
      }
    },
    3953=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [53,54,56,61,62,64,208,218,225,242],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [53,54,56,61,62,64,208,218,225,242,401,424,426],
        :socket=>{3=>100},
      }
    },
    3954=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [65,66,68,113,114,116,219,220,221,223,226,227,236,237,244],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [65,66,68,113,114,116,219,220,221,223,226,227,236,237,244,401,427,439],
        :socket=>{3=>100},
      }
    },
    3955=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [5,6,8,9,10,12,203,216,225,230,231,241,243],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [5,6,8,9,10,12,203,216,225,230,231,241,243,401,412,413],
        :socket=>{3=>100},
      }
    },
    3956=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [17,18,20,65,66,68,204,219,220,221,223,226,227,244],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [17,18,20,65,66,68,204,219,220,221,223,226,227,244,401,415,427],
        :socket=>{3=>100},
      }
    },
    3957=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [61,62,64,69,70,72,210,218,225,242],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [61,62,64,69,70,72,210,218,225,242,401,426,428],
        :socket=>{3=>100},
      }
    },
    3958=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [9,10,12,29,30,32,203,206,225,231,241,243],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [9,10,12,29,30,32,203,206,225,231,241,243,401,413,418],
        :socket=>{3=>100},
      }
    },
    3959=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [65,66,68,69,70,72,210,219,220,221,223,225,226,227,244],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [65,66,68,69,70,72,210,219,220,221,223,225,226,227,244,401,427,428],
        :socket=>{3=>100},
      }
    },
    3960=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [25,26,28,29,30,32,206],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [25,26,28,29,30,32,206,401,417,418],
        :socket=>{3=>100},
      }
    },
    3961=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [65,66,68,219,220,221,223,226,227,244],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [65,66,68,219,220,221,223,226,227,244,401,427],
        :socket=>{3=>100},
      }
    },
    3962=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [21,22,24,121,122,124,203,219],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [21,22,24,121,122,124,203,219,401,416,441],
        :socket=>{3=>100},
      }
    },
    3963=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [41,42,44,121,122,124,217,231,244],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [41,42,44,121,122,124,217,231,244,401,421,441],
        :socket=>{3=>100},
      }
    },

  # コラボ武器
    4051=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [9,10,12,203,225,231,241,243,401,413,501],
        :socket=>{3=>100},
      }
    },
    4052=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [65,66,68,219,220,221,223,226,227,401,427,504],
        :socket=>{3=>100},
      }
    },
    4053=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [69,70,72,210,225,401,428,510],
        :socket=>{3=>100},
      }
    },
    4054=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [61,62,64,218,225,242,401,426,513],
        :socket=>{3=>100},
      }
    },
    4055=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [41,42,44,217,231,401,421,515],
        :socket=>{3=>100},
      }
    },
    4056=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [65,66,68,219,220,221,223,226,227,401,427,517],
        :socket=>{3=>100},
      }
    },
    4057=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [65,66,68,219,220,221,223,226,227,401,420,427,433,441,519],
        :socket=>{3=>100},
      }
    },
    4058=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [73,74,76,211,401,429,522],
        :socket=>{3=>100},
      }
    },
    4059=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [117,118,120,215,224,235,238,242,401,440,539],
        :socket=>{3=>100},
      }
    },
    4060=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [65,66,68,219,220,221,223,226,227,401,427,540],
        :socket=>{3=>100},
      }
    },
    4061=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [21,22,24,203,219,401,416,433,541],
        :socket=>{3=>100},
      }
    },
    4062=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [73,74,76,211,401,429,544],
        :socket=>{3=>100},
      }
    },
    4063=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [33,34,36,205,216,401,419,546],
        :socket=>{3=>100},
      }
    },
    4064=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [21,22,24,203,219,401,416,420,433,548],
        :socket=>{3=>100},
      }
    },
    4065=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [41,42,44,217,231,401,421,525],
        :socket=>{3=>100},
      }
    },
    4066=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [53,54,56,208,401,424,528],
        :socket=>{3=>100},
      }
    },
    4067=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [65,66,68,219,220,221,223,226,227,401,421,427,428,533],
        :socket=>{3=>100},
      }
    },
    4068=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [9,10,12,203,225,231,241,243,401,413,551],
        :socket=>{3=>100},
      }
    },
    4069=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [41,42,44,217,231,401,421,556],
        :socket=>{3=>100},
      }
    },
    4070=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [41,42,44,217,231,401,421,559],
        :socket=>{3=>100},
      }
    },
    4071=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [65,66,68,219,220,221,223,226,227,401,427,560],
        :socket=>{3=>100},
      }
    },
    4072=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [13,14,16,203,401,414,562],
        :socket=>{3=>100},
      }
    },
    4073=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [89,90,92,214,233,401,425,433,566],
        :socket=>{3=>100},
      }
    },
    4074=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [57,58,60,209,226,227,401,425,569],
        :socket=>{3=>100},
      }
    },
    4075=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [41,42,44,217,231,401,421,572],
        :socket=>{3=>100},
      }
    },
    4076=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [21,22,24,203,219,401,416,574],
        :socket=>{3=>100},
      }
    },
    4077=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [21,22,24,203,219,401,416,534],
        :socket=>{3=>100},
      }
    }
  }
end

#==============================================================================
# ■ NWConst::Armor
#==============================================================================
module NWConst::Armor
  ENCAHNT_DATA ={
  # 服
    2501..2506=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [125],
        :socket=>{3=>100},
      },
    },
    2507..2510=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [125,126,200,260],
        :socket=>{3=>100},
      },
    },
    2511..2516=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [127],
        :socket=>{3=>100},
      },
    },
    2517..2520=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [127,128,201],
        :socket=>{3=>100},
      },
    },
    2521..2550=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [125,126,128,200,260],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [125,126,128,200,260,402],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [125,126,128,200,260,402],
        :socket=>{3=>100},
      }
    },

  # 武道着
    2551..2556=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [129],
        :socket=>{3=>100},
      },
    },
    2557..2560=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [129,130,200,251],
        :socket=>{3=>100},
      },
    },
    2561..2566=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [131],
        :socket=>{3=>100},
      },
    },
    2567..2570=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [131,132,201,251],
        :socket=>{3=>100},
      },
    },
    2571..2600=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [129,130,132,200,251],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [129,130,132,200,251,402],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [129,130,132,200,251,402],
        :socket=>{3=>100},
      }
    },

  # 胸当て
    2601..2606=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [133],
        :socket=>{3=>100},
      },
    },
    2607..2610=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [133,134,200,248,250,255,257,260],
        :socket=>{3=>100},
      },
    },
    2611..2616=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [135],
        :socket=>{3=>100},
      },
    },
    2617..2620=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [135,136,201,248,250,255,257,260],
        :socket=>{3=>100},
      },
    },
    2621..2650=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [133,134,136,200,248,250,255,257,260],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [133,134,136,200,248,250,255,257,260,402],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [133,134,136,200,248,250,255,257,260,402],
        :socket=>{3=>100},
      }
    },

  # 鎧
    2651..2656=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [137],
        :socket=>{3=>100},
      },
    },
    2657..2660=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [137,138,200,245,249,257,260],
        :socket=>{3=>100},
      },
    },
    2661..2666=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [139],
        :socket=>{3=>100},
      },
    },
    2667..2670=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [139,140,201,245,249,257,260],
        :socket=>{3=>100},
      },
    },
    2671..2700=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [137,138,140,200,245,249,257,260],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [137,138,140,200,245,249,257,260,402],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [137,138,140,200,245,249,257,260,402],
        :socket=>{3=>100},
      }
    },

  # 重鎧
    2701..2706=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [141],
        :socket=>{3=>100},
      },
    },
    2707..2710=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [141,142,200,245,254],
        :socket=>{3=>100},
      },
    },
    2711..2716=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [143],
        :socket=>{3=>100},
      },
    },
    2717..2720=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [143,144,201,245,254],
        :socket=>{3=>100},
      },
    },
    2721..2800=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [141,142,144,200,245,254],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [141,142,144,200,245,254,402],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [141,142,144,200,245,254,402],
        :socket=>{3=>100},
      }
    },

  # 甲羅
    2801..2806=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [145],
        :socket=>{3=>100},
      },
    },
    2807..2810=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [145,146,200,247,252,257],
        :socket=>{3=>100},
      },
    },
    2811..2816=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [147],
        :socket=>{3=>100},
      },
    },
    2817..2820=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [147,148,201,247,252,257],
        :socket=>{3=>100},
      },
    },
    2821..2850=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [145,146,148,200,247,252,257],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [145,146,148,200,247,252,257,402],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [145,146,148,200,247,252,257,402],
        :socket=>{3=>100},
      }
    },

  # ローブ
    2851..2856=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [149],
        :socket=>{3=>100},
      },
    },
    2857..2860=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [149,150,200,245,246,253,254,256],
        :socket=>{3=>100},
      },
    },
    2861..2866=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [151],
        :socket=>{3=>100},
      },
    },
    2867..2870=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [151,152,201,245,246,253,254,256],
        :socket=>{3=>100},
      },
    },
    2871..2950=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [149,150,152,200,245,246,253,254,256],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [149,150,152,200,245,246,253,254,256,402],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [149,150,152,200,245,246,253,254,256,402],
        :socket=>{3=>100},
      }
    },

  # ドレス
    2951..2956=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [153],
        :socket=>{3=>100},
      },
    },
    2957..2960=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [153,154,200,245,256],
        :socket=>{3=>100},
      },
    },
    2961..2966=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [155],
        :socket=>{3=>100},
      },
    },
    2967..2970=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [155,156,201,245,256],
        :socket=>{3=>100},
      },
    },
    2971..3050=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [153,154,156,200,245,256],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [153,154,156,200,245,256,402],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [153,154,156,200,245,256,402],
        :socket=>{3=>100},
      }
    },

  # 薄着
    3051..3056=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [157],
        :socket=>{3=>100},
      },
    },
    3057..3060=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [157,158,200,250,251,255,256,260],
        :socket=>{3=>100},
      },
    },
    3061..3066=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [159],
        :socket=>{3=>100},
      },
    },
    3067..3070=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [159,160,201,250,251,255,256,260],
        :socket=>{3=>100},
      },
    },
    3071..3150=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [157,158,160,200,250,251,255,256,260],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [157,158,160,200,250,251,255,256,260,402],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [157,158,160,200,250,251,255,256,260,402],
        :socket=>{3=>100},
      }
    },

  # 帽子
    3151..3156=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [161],
        :socket=>{3=>100},
      },
    },
    3157..3160=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [161,162,200],
        :socket=>{3=>100},
      },
    },
    3161..3166=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [163],
        :socket=>{3=>100},
      },
    },
    3167..3170=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [163,164,201],
        :socket=>{3=>100},
      },
    },
    3171..3200=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [161,162,164,200],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [161,162,164,200,403],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [161,162,164,200,403],
        :socket=>{3=>100},
      }
    },

  # 兜
    3201..3206=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [165],
        :socket=>{3=>100},
      },
    },
    3207..3210=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [165,166,200],
        :socket=>{3=>100},
      },
    },
    3211..3216=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [167],
        :socket=>{3=>100},
      },
    },
    3217..3220=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [167,168,201],
        :socket=>{3=>100},
      },
    },
    3221..3250=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [165,166,168,200],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [165,166,168,200,403],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [165,166,168,200,403],
        :socket=>{3=>100},
      }
    },

  # 重兜
    3251..3256=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [169],
        :socket=>{3=>100},
      },
    },
    3257..3260=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [169,170,200],
        :socket=>{3=>100},
      },
    },
    3261..3266=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [171],
        :socket=>{3=>100},
      },
    },
    3267..3270=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [171,172,201],
        :socket=>{3=>100},
      },
    },
    3271..3350=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [169,170,172,200],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [169,170,172,200,403],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [169,170,172,200,403],
        :socket=>{3=>100},
      }
    },

  # 魔帽
    3351..3356=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [173],
        :socket=>{3=>100},
      },
    },
    3357..3360=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [173,174,200],
        :socket=>{3=>100},
      },
    },
    3361..3366=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [175],
        :socket=>{3=>100},
      },
    },
    3367..3370=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [175,176,201],
        :socket=>{3=>100},
      },
    },
    3371..3400=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [173,174,176,200],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [173,174,176,200,403],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [173,174,176,200,403],
        :socket=>{3=>100},
      }
    },

  # 高級帽
    3401..3406=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [177],
        :socket=>{3=>100},
      },
    },
    3407..3410=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [177,178,200],
        :socket=>{3=>100},
      },
    },
    3411..3416=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [179],
        :socket=>{3=>100},
      },
    },
    3417..3420=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [179,180,201],
        :socket=>{3=>100},
      },
    },
    3421..3450=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [177,178,180,200],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [177,178,180,200,403],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [177,178,180,200,403],
        :socket=>{3=>100},
      }
    },

  # 軽盾
    3451..3456=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [181],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [181],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [181],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [181],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [181],
        :socket=>{3=>100},
      }
    },
    3457..3460=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [181,182,200],
        :socket=>{3=>100},
      },
    },
    3461..3466=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [183],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [183],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [183],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [183],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [183],
        :socket=>{3=>100},
      }
    },
    3467..3470=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [183,184,201],
        :socket=>{3=>100},
      },
    },
    3471..3500=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [181,182,184,200],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [181,182,184,200,404],
        :socket=>{3=>100},
      }
    },

  # 盾
    3501..3506=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [185],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [185],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [185],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [185],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [185],
        :socket=>{3=>100},
      }
    },
    3507..3510=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [185,186,200],
        :socket=>{3=>100},
      },
    },
    3511..3516=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [187],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [187],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [187],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [187],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [187],
        :socket=>{3=>100},
      }
    },
    3517..3520=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [187,188,201],
        :socket=>{3=>100},
      },
    },
    3521..3550=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [185,186,188,200],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [185,186,188,200,404],
        :socket=>{3=>100},
      }
    },

  # 重盾
    3551..3556=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [189],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [189],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [189],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [189],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [189],
        :socket=>{3=>100},
      }
    },
    3557..3560=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [189,190,200,264],
        :socket=>{3=>100},
      },
    },
    3561..3566=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..2000 =>{
        :enchants => [191],
        :socket=>{3=>100},
      },
      2001..4000 =>{
        :enchants => [191],
        :socket=>{3=>100},
      },
      4001..6000 =>{
        :enchants => [191],
        :socket=>{3=>100},
      },
      6001..8000 =>{
        :enchants => [191],
        :socket=>{3=>100},
      },
      8001..30000 =>{
        :enchants => [191],
        :socket=>{3=>100},
      }
    },
    3567..3570=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [191,192,201,264],
        :socket=>{3=>100},
      },
    },
    3571..3650=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [189,190,192,200,264],
        :socket=>{3=>100},
      },
      10001..30000 =>{
        :enchants => [189,190,192,200,404,264],
        :socket=>{3=>100},
      }
    },

  # アクセサリ
    3651..3659=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [193],
        :socket=>{3=>100},
      },
    },
    3660..3665=>{
      :enchant_count =>2..3,
      :display_color => 1,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [195],
        :socket=>{3=>100},
      },
    },
    3666..3671=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [193,194],
        :socket=>{3=>100},
      },
    },
    3672..3675=>{
      :enchant_count =>3..4,
      :display_color => 2,
      :not_prefix => 0,
      1..30000 =>{
        :enchants => [195,196],
        :socket=>{3=>100},
      },
    },
    3676..3750=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..10000 =>{
        :enchants => [193,194,196],
        :socket=>{3=>100},
      },
      10001..20000 =>{
        :enchants => [193,194,196,405],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405],
        :socket=>{3=>100},
      }
    },

  # コラボ防具
    3751=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [125,126,128,200,260,402,502],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [125,126,128,200,260,402,502],
        :socket=>{3=>100},
      }
    },
    3752=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,503],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,503],
        :socket=>{3=>100},
      }
    },
    3753=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [153,154,156,200,245,256,402,505],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [153,154,156,200,245,256,402,505],
        :socket=>{3=>100},
      }
    },
    3754=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [177,178,180,200,403,506],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [177,178,180,200,403,506],
        :socket=>{3=>100},
      }
    },
    3755=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,507],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,507],
        :socket=>{3=>100},
      }
    },
    3756=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [153,154,156,200,245,256,402,508],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [153,154,156,200,245,256,402,508],
        :socket=>{3=>100},
      }
    },
    3757=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,509],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,509],
        :socket=>{3=>100},
      }
    },
    3758=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,512],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,512],
        :socket=>{3=>100},
      }
    },
    3759=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,514],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,514],
        :socket=>{3=>100},
      }
    },
    3760=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,516],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,516],
        :socket=>{3=>100},
      }
    },
    3761=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [157,158,160,200,250,251,255,256,260,402,511],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [157,158,160,200,250,251,255,256,260,402,511],
        :socket=>{3=>100},
      }
    },
    3762=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,518],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,518],
        :socket=>{3=>100},
      }
    },
    3763=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [153,154,156,200,245,256,402,520],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [153,154,156,200,245,256,402,520],
        :socket=>{3=>100},
      }
    },
    3764=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,521],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,521],
        :socket=>{3=>100},
      }
    },
    3765=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [177,178,180,200,403,523],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [177,178,180,200,403,523],
        :socket=>{3=>100},
      }
    },
    3766=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,524],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,524],
        :socket=>{3=>100},
      }
    },
    3767=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [137,138,140,200,245,249,257,260,402,542],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [137,138,140,200,245,249,257,260,402,542],
        :socket=>{3=>100},
      }
    },
    3768=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,543],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,543],
        :socket=>{3=>100},
      }
    },
    3769=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,545],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,545],
        :socket=>{3=>100},
      }
    },
    3770=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,547],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,547],
        :socket=>{3=>100},
      }
    },
    3771=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [153,154,156,200,245,256,402,549],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [153,154,156,200,245,256,402,549],
        :socket=>{3=>100},
      }
    },
    3772=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [129,130,132,200,251,402,526],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [129,130,132,200,251,402,526],
        :socket=>{3=>100},
      }
    },
    3773=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,527],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,527],
        :socket=>{3=>100},
      }
    },
    3774=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [125,126,128,200,260,402,529],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [125,126,128,200,260,402,529],
        :socket=>{3=>100},
      }
    },
    3775=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,530],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,530],
        :socket=>{3=>100},
      }
    },
    3776=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [125,126,128,200,260,402,531],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [125,126,128,200,260,402,531],
        :socket=>{3=>100},
      }
    },
    3777=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [177,178,180,200,403,532],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [177,178,180,200,403,532],
        :socket=>{3=>100},
      }
    },
    3778=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [141,142,144,200,245,254,402,552],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [141,142,144,200,245,254,402,552],
        :socket=>{3=>100},
      }
    },
    3779=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [169,170,172,200,403,553],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [169,170,172,200,403,553],
        :socket=>{3=>100},
      }
    },
    3780=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [189,190,192,200,404,554],
        :socket=>{3=>100},
      }
    },
    3781=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,555],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,555],
        :socket=>{3=>100},
      }
    },
    3782=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [125,126,128,200,260,402,557],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [125,126,128,200,260,402,557],
        :socket=>{3=>100},
      }
    },
    3783=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,561],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,561],
        :socket=>{3=>100},
      }
    },
    3784=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [169,170,172,200,403,563],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [169,170,172,200,403,563],
        :socket=>{3=>100},
      }
    },
    3785=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [189,190,192,200,404,564],
        :socket=>{3=>100},
      }
    },
    3786=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,565],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,565],
        :socket=>{3=>100},
      }
    },
    3787=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [161,162,164,200,403,567],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [161,162,164,200,403,567],
        :socket=>{3=>100},
      }
    },
    3788=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,568],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,568],
        :socket=>{3=>100},
      }
    },
    3789=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,571],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,571],
        :socket=>{3=>100},
      }
    },
    3790=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,573],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,573],
        :socket=>{3=>100},
      }
    },
    3791=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,575],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,575],
        :socket=>{3=>100},
      }
    },
    3792=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..30000 =>{
        :enchants => [185,186,188,200,404,535],
        :socket=>{3=>100},
      }
    },
    3793=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [149,150,152,200,245,246,253,254,256,402,536],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [149,150,152,200,245,246,253,254,256,402,536],
        :socket=>{3=>100},
      }
    },
    3794=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [173,174,176,200,403,537],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [173,174,176,200,403,537],
        :socket=>{3=>100},
      }
    },
    3795=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,538],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,538],
        :socket=>{3=>100},
      }
    },
    3796=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,550],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,550],
        :socket=>{3=>100},
      }
    },
    3797=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405,558],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405,558],
        :socket=>{3=>100},
      }
    },
    3798=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [125,126,128,200,260,402,570],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [125,126,128,200,260,402,570],
        :socket=>{3=>100},
      }
    },
    3799=>{
      :enchant_count =>4..5,
      :display_color => 3,
      :not_prefix => 1,
      1..20000 =>{
        :enchants => [193,194,196,405],
        :socket=>{3=>100},
      },
      20001..30000 =>{
        :enchants => [193,194,196,405],
        :socket=>{3=>100},
      }
    }
  }
end